import request from '@/utils/request'

// 查询列表
export function listSapDict(query) {
  return request({
    url: '/md/sapDict/list',
    method: 'get',
    params: query
  })
}

// 查询详细
export function getSapDict(id) {
  return request({
    url: '/md/sapDict/' + id,
    method: 'get'
  })
}

// 新增
export function addSapDict(data) {
  return request({
    url: '/md/sapDict',
    method: 'post',
    data: data
  })
}

// 修改
export function updateSapDict(data) {
  return request({
    url: '/md/sapDict',
    method: 'put',
    data: data
  })
}

// 删除
export function delSapDict(id) {
  return request({
    url: '/md/sapDict/' + id,
    method: 'delete'
  })
}
