import request from '@/utils/request'

// 查询车间异常单列表
export function listReport(query) {
  return request({
    url: '/qc/report/list',
    method: 'get',
    params: query
  })
}

// 查询车间异常单详细
export function getReport(abnormalReportId) {
  return request({
    url: '/qc/report/' + abnormalReportId,
    method: 'get'
  })
}

// 新增车间异常单
export function addReport(data) {
  return request({
    url: '/qc/report',
    method: 'post',
    data: data
  })
}

// 修改车间异常单
export function updateReport(data) {
  return request({
    url: '/qc/report',
    method: 'put',
    data: data
  })
}

// 删除车间异常单
export function delReport(abnormalReportId) {
  return request({
    url: '/qc/report/' + abnormalReportId,
    method: 'delete'
  })
}

// 开始车间异常单
export function startReport(abnormalReportId) {
  return request({
    url: '/qc/report/start/' + abnormalReportId,
    method: 'post'
  })
}

// 完成车间异常单
export function completeReport(data) {
  return request({
    url: '/qc/report/complete',
    method: 'put',
    data: data
  })
}

// 关闭车间异常单
export function closeReport(data) {
  return request({
    url: '/qc/report/close',
    method: 'put',
    data: data
  })
}