import request from '@/utils/request'

// 查询产品序列号打印记录列表
export function listQrcodeRecord(query) {
  return request({
    url: '/pro/qrcodeRecord/list',
    method: 'get',
    params: query
  })
}

// 查询产品序列号打印记录详细
export function getQrcodeRecord(recordId) {
  return request({
    url: '/pro/qrcodeRecord/' + recordId,
    method: 'get'
  })
}

// 新增产品序列号打印记录
export function addQrcodeRecord(data) {
  return request({
    url: '/pro/qrcodeRecord',
    method: 'post',
    data: data
  })
}

// 修改产品序列号打印记录
export function updateQrcodeRecord(data) {
  return request({
    url: '/pro/qrcodeRecord',
    method: 'put',
    data: data
  })
}

// 修改打印次数
export function editList(data) {
  return request({
    url: '/pro/qrcodeRecord/editList',
    method: 'put',
    data: data
  })
}

// 删除产品序列号打印记录
export function delQrcodeRecord(recordId) {
  return request({
    url: '/pro/qrcodeRecord/' + recordId,
    method: 'delete'
  })
}
