import request from '@/utils/request'

// 查询刀模板领用单列表
export function listTmToolRequestUse(query) {
  return request({
    url: '/tm/tmToolRequestUse/list',
    method: 'get',
    params: query
  })
}

// 查询刀模板领用单详细
export function getTmToolRequestUse(toolRequestUseId) {
  return request({
    url: '/tm/tmToolRequestUse/' + toolRequestUseId,
    method: 'get'
  })
}

// 新增刀模板领用单
export function addTmToolRequestUse(data) {
  return request({
    url: '/tm/tmToolRequestUse',
    method: 'post',
    data: data
  })
}

// 修改刀模板领用单
export function updateTmToolRequestUse(data) {
  return request({
    url: '/tm/tmToolRequestUse',
    method: 'put',
    data: data
  })
}

// 删除刀模板领用单
export function delTmToolRequestUse(toolRequestUseId) {
  return request({
    url: '/tm/tmToolRequestUse/' + toolRequestUseId,
    method: 'delete'
  })
}
