import request from '@/utils/request'

// 查询销售订单分销渠道列表
export function listChannel(query) {
  return request({
    url: '/md/channel/list',
    method: 'get',
    params: query
  })
}

// 查询销售订单分销渠道详细
export function getChannel(id) {
  return request({
    url: '/md/channel/' + id,
    method: 'get'
  })
}

// 新增销售订单分销渠道
export function addChannel(data) {
  return request({
    url: '/md/channel',
    method: 'post',
    data: data
  })
}

// 修改销售订单分销渠道
export function updateChannel(data) {
  return request({
    url: '/md/channel',
    method: 'put',
    data: data
  })
}

// 删除销售订单分销渠道
export function delChannel(id) {
  return request({
    url: '/md/channel/' + id,
    method: 'delete'
  })
}
