import request from "@/utils/request";

// 查询生产报工记录列表
export function workorderList(query) {
  return request({
    url: "/mes/pro/workorder/list",
    method: "get",
    params: query,
  });
}


// 查询标签列表
export function workorderPackageList(query) {
  return request({
    url: "/pro/packagePrintRecord/list",
    method: "get",
    params: query,
  });
}


// 装箱标签生成
export function buildPackagePrint(data) {
  return request({
    url: "/mes/pro/workorder/buildPackagePrint",
    method: "post",
    data: data,
  });
}

// 批量修改打印记录
export function updatePackagePrintRecord(data) {
  return request({
    url: "/pro/packagePrintRecord/batchUpdate",
    method: "post",
    data: data,
  });
}

// 记录打印次数并返回打印数据
export function packagePrintRecordInfo(data) {
  return request({
    url: "/pro/packagePrintRecord/recordPackagePrintInfo",
    method: "post",
    data
  });
}

