import request from '@/utils/request'

// 查询工作单元列表
export function listWorkunit(query) {
  return request({
    url: '/md/workunit/list',
    method: 'get',
    params: query
  })
}
// 根据工作单元查询上机明细
export function listWorkTmToolRequestList(query) {
  return request({
    url: "/md/workunit/getUpTmToolRequestList",
    method: "get",
    params: query,
  });
}

// 查询工作单元详细
export function getWorkunit(workunitId) {
  return request({
    url: '/md/workunit/' + workunitId,
    method: 'get'
  })
}

// 新增工作单元
export function addWorkunit(data) {
  return request({
    url: '/md/workunit',
    method: 'post',
    data: data
  })
}

// 修改工作单元
export function updateWorkunit(data) {
  return request({
    url: '/md/workunit',
    method: 'put',
    data: data
  })
}

// 删除工作单元
export function delWorkunit(workunitId) {
  return request({
    url: '/md/workunit/' + workunitId,
    method: 'delete'
  })
}
