import request from '@/utils/request'

// 查询生产编排单列表
export function getListData(query) {
  return request({
    url: `/mes/pro/taskWorkunit/list?pageNum=${query.pageNum}&pageSize=${query.pageSize}`,
    method: "post",
    data: query,
  });
}

// 修改生产任务数据
export function updateList(query) {
  return request({
    url: "/mes/pro/taskWorkunit/updateTimeAndWorkunit",
    method: "post",
    data: query
  });
}
// 下达生产
export function makeProduction(query) {
  return request({
    url: "/mes/pro/taskWorkunit/makeProduction",
    method: "post",
    data: query
  });
}

// 排程
export function makeSchedule(query) {
  return request({
    url: "/mes/pro/protask/schedule",
    method: "post",
    data: query,
    timeout: 120000
  });
}

// 关联工单表查询编排表（合并重复项）
export function arrangeList(query) {
  return request({
    url: "/pro/arrange/list2",
    method: "post",
    data: query,
  });
}

// 查询待排产生产工单列表
export function scheduleList(query) {
  return request({
    url: "/mes/pro/workorder/scheduleList",
    method: "get",
    params: query,
  });
}

// 查询任务工作单元列表
export function taskWorkunitList(query) {
  return request({
    url: "/mes/pro/taskWorkunit/workorderList",
    method: "post",
    data: query
  });
}

// 车间列表查询
export function getworkshopList(query) {
  // workshopId workshopName
  return request({
    url: "/mes/md/workshop/list",
    method: "get"
  });
}

// 工作中心查询
export function getworkstationList(query) {
  // workshopId workstationId workstationName
  return request({
    url: "/mes/md/workstation/list",
    method: "get",
    params: query
  });
}

// 查询任务工作单元列表
export function gettaskWorkunitList(query) {
  // workshopId workCenterId = workstationId workstationName  workunitId workunitName
  return request({
    url: "md/workunit/list",
    method: "get",
    params: query,
  });
}

// 默认工作中心查询
export function getdefaultWorkCenterList() {
  // workshopId workCenterId = workstationId workstationName  workunitId workunitName
  return request({
    url: "/mes/md/workstation/defaultList",
    method: "get"
  });
}

// 转委外
export function toOutsource(query) {
  return request({
    url: "/mes/pro/taskWorkunit/toOutsource",
    method: "post",
    data: query
  });
}

// 拆分
export function outsourceSplit(query) {
  return request({
    url: "/mes/pro/taskWorkunit/outsourceSplit",
    method: "post",
    data: query
  });
}

// 拆分
export function toSelfMade(query) {
  return request({
    url: "/mes/pro/taskWorkunit/toSelfMade",
    method: "post",
    data: query
  });
}

// 委外确认
export function outsourceConfirm(query) {
  return request({
    url: "/mes/pro/taskWorkunit/outsourceConfirm",
    method: "post",
    data: query
  });
}

// 打印
export function printData(query) {
  return request({
    url: "/mes/pro/taskWorkunit/printData",
    method: "post",
    data: query
  });
}

// 打印
export function printDataBySpil(query) {
  return request({
    url: "/mes/pro/taskWorkunit/printDataBySpil",
    method: "post",
    data: query
  });
}

// 完工作业
export function change(query) {
  return request({
    url: "/mobile/pro/protask/change",
    method: "post",
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    params: query
  });
}

// 完工作业
export function rollBACKschedule(query) {
  return request({
    url: "/mes/pro/protask/rollBACKschedule",
    method: "post",
    data: query
  });
}