import request from '@/utils/request'

// 查询产品二维码规则列表
export function listProQrcodeRule(query) {
  return request({
    url: '/pro/proQrcodeRule/list',
    method: 'get',
    params: query
  })
}

// 查询产品二维码规则详细
export function getProQrcodeRule(ruleId) {
  return request({
    url: '/pro/proQrcodeRule/' + ruleId,
    method: 'get'
  })
}

// 新增产品二维码规则
export function addProQrcodeRule(data) {
  return request({
    url: '/pro/proQrcodeRule',
    method: 'post',
    data: data
  })
}

// 修改产品二维码规则
export function updateProQrcodeRule(data) {
  return request({
    url: '/pro/proQrcodeRule',
    method: 'put',
    data: data
  })
}

// 删除产品二维码规则
export function delProQrcodeRule(ruleId) {
  return request({
    url: '/pro/proQrcodeRule/' + ruleId,
    method: 'delete'
  })
}
