import request from '@/utils/request'

// 查询客户采购订单列表
export function listOrder(query) {
  return request({
    url: '/od/purchaseOrder/list',
    method: 'get',
    params: query
  })
}

// 查询客户采购订单详细
export function getOrder(id) {
  return request({
    url: '/od/purchaseOrder/' + id,
    method: 'get'
  })
}

export function getSalesOrder(purchaseId) {
  return request({
    url: '/od/purchaseOrder/getSalesOrder?id=' + purchaseId,
    method: 'get'
  })
}

// 新增客户采购订单
export function addOrder(data) {
  return request({
    url: '/od/purchaseOrder',
    method: 'post',
    data: data
  })
}

// 修改客户采购订单
export function updateOrder(data) {
  return request({
    url: '/od/purchaseOrder',
    method: 'put',
    data: data
  })
}

// 删除客户采购订单
export function delOrder(id) {
  return request({
    url: '/od/purchaseOrder/' + id,
    method: 'delete'
  })
}
