import request from '@/utils/request'

// 查询编排单对照表列表
export function listProWorkOrderArrangeRule(query) {
  return request({
    url: '/mes/pro/ProWorkOrderArrangeRule/list',
    method: 'get',
    params: query
  })
}

// 查询编排单对照表详细
export function getProWorkOrderArrangeRule(arrangeRuleId) {
  return request({
    url: '/mes/pro/ProWorkOrderArrangeRule/' + arrangeRuleId,
    method: 'get'
  })
}

// 新增编排单对照表
export function addProWorkOrderArrangeRule(data) {
  return request({
    url: '/mes/pro/ProWorkOrderArrangeRule',
    method: 'post',
    data: data
  })
}

// 修改编排单对照表
export function updateProWorkOrderArrangeRule(data) {
  return request({
    url: '/mes/pro/ProWorkOrderArrangeRule',
    method: 'put',
    data: data
  })
}

// 删除编排单对照表
export function delProWorkOrderArrangeRule(arrangeRuleId) {
  return request({
    url: '/mes/pro/ProWorkOrderArrangeRule/' + arrangeRuleId,
    method: 'delete'
  })
}
