import request from '@/utils/request'

// 查询生产用途列表
export function listUsage(query) {
  return request({
    url: '/mes/pro/usage/list',
    method: 'get',
    params: query
  })
}

// 查询所有有效生产用途
export function listAllUsage() {
  return request({
    url: '/mes/pro/usage/listAll',
    method: 'get'
  })
}


// 查询生产用途详细
export function getUsage(usageId) {
  return request({
    url: '/mes/pro/usage/' + usageId,
    method: 'get'
  })
}

// 新增生产用途
export function addUsage(data) {
  return request({
    url: '/mes/pro/usage',
    method: 'post',
    data: data
  })
}

// 修改生产用途
export function updateUsage(data) {
  return request({
    url: '/mes/pro/usage',
    method: 'put',
    data: data
  })
}

// 删除生产用途
export function delUsage(usageId) {
  return request({
    url: '/mes/pro/usage/' + usageId,
    method: 'delete'
  })
}
