import Vue from "vue";
import VueI18n from "vue-i18n";
// 引入自定义语言
import zh from "./lang/zh_CN.json";
import th from "./lang/th_TH.json";
// 引入element框架语言
import ElementLocale from "element-ui/lib/locale";
import thLocale from "element-ui/lib/locale/lang/th";
import zhLocale from "element-ui/lib/locale/lang/zh-CN";

ElementLocale.i18n((key, value) => i18n.t(key, value));
Vue.use(VueI18n);
// 准备翻译的语言环境信息
const i18n = new VueI18n({
  locale: localStorage.getItem("lang") || "zh", //将语言标识存入localStorage或sessionStorage中，页面刷新不会默认中文显示
  messages: {
    // 中文语言包
    zh: {
      ...zh,
      ...zhLocale,
    },
    //英文语言包
    th: {
      ...th,
      ...thLocale,
    },
  },
  silentTranslationWarn: true, //解决vue-i18n黄色警告"value of key 'xxx' is not a string"和"cannot translate the value of keypath 'xxx'.use the value of keypath as default",可忽略
  globalInjection: true, // 全局注入
  fallbackLocale: "zh", // 指定的locale没有找到对应的资源或当前语种不存在时，默认设置当前语种为中文
});

export const langs = [
    { value: 'zh-CN', label: '中文' },
    { value: 'th-TH', label: 'ภาษาไทย' }
]

export const getLocaleText = (lang) => {
    return langs.find(item => item.value == lang).label
}

export const setLocal = (lang) => {
    localStorage.setItem('lang', lang)
    i18n.locale = lang
}

export default i18n;