import request from '@/utils/request'

// 查询操作日志列表
export function list(query) {
  return request({
    url: '/monitor/apiLog/list',
    method: 'get',
    params: query
  })
}

// 删除操作日志
export function delApilog(operId) {
  return request({
    url: '/monitor/apiLog/' + operId,
    method: 'delete'
  })
}

// 清空操作日志
export function cleanApilog() {
    return request({
        url: '/monitor/apiLog/clean',
        method: 'delete'
    })
}

// 再执行操作
export function executeOperation(param) {
    return request({
        url: '/monitor/apiLog/execute',
        method: 'post',
        data: param
    })
}
