import Vue from 'vue';
import VueI18n from 'vue-i18n';
import zh from './zh_CN.json';
import th from "./th_TH.json";
// 需要什么语言都要导入
 
// 使用 Vue 2 的 VueI18n
Vue.use(VueI18n);
 
const i18n = new VueI18n({
  locale: uni.getStorageSync('lang') || 'zh', // 默认语言为中文
  messages: {
    th,
    zh,
  },
  silentTranslationWarn: true, //解决vue-i18n黄色警告"value of key 'xxx' is not a string"和"cannot translate the value of keypath 'xxx'.use the value of keypath as default",可忽略
  globalInjection: true, // 全局注入
  fallbackLocale: "zh", // 指定的locale没有找到对应的资源或当前语种不存在时，默认设置当前语种为中文
});

export const setLocal = (lang) => {
    uni.setStorageSync('lang', lang)
    i18n.locale = lang
}
 
export default i18n;