/**
 * Copyright (c) 2013-Now http://aidex.vip All rights reserved.
 */
// 此处第二个参数vm，就是我们在页面使用的this，你可以通过vm获取vuex等操作
const install = (Vue, vm) => {

    // 参数配置对象
    const config = vm.vuex_config;

    // 将各个定义的接口名称，统一放进对象挂载到vm.$u.api(因为vm就是this，也即this.$u.api)下
    vm.$u.api = {

        // 基础服务：登录登出、身份信息、菜单授权、切换系统、字典数据等
        lang: (params = {}) => vm.$u.get('/lang/' + params.lang),
        index: (params = {}) => vm.$u.get(config.adminPath + '/mobile/index', params),
        getUserInfo: (params = {}) => vm.$u.get(config.adminPath + '/mobile/user/getUserInfo', params),
        login: (params = {}) => vm.$u.post('/mobile/login/loginByPassword', params),
        sendCode: (params = {}) => vm.$u.post(config.adminPath + '/mobile/login/sendCode', params),
        registerUser: (params = {}) => vm.$u.post(config.adminPath + '/mobile/user/registerUser', params),

        // 个人信息修改
        user: {
            saveUserInfo: (params = {}) => vm.$u.post(config.adminPath + '/mobile/user/saveUserInfo', params),
            infoSavePwd: (params = {}) => vm.$u.put(config.adminPath + '/system/user/profile/updatePwd',
                params),
            infoSavePqa: (params = {}) => vm.$u.post(config.adminPath + '/sys/user/infoSavePqa', params),
        },

        // 员工用户查询
        empUser: {
            listData: (params = {}) => vm.$u.get(config.adminPath + '/sys/empUser/listData', params),
        },
		sapApi: {
			// 采购入库
			sapRrm: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/cud_mm_rrm/rrm?sap-client=300', params),
			sapPlnr: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/get_mm_plnr/plnr?sap-client=300', params,),
			// 仓位转移
			sapDict: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/ep_dict?sap-client=300', params),
			// 生产领料
			sapProiss: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_plto_proiss?sap-client=300', params),
			// 完工入库
			sapOrder: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/PDA_MES_Order/PDA_ORDER?sap-client=300', params),
			// 线边库转移下架
			sapXbkzy: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_plto_xbkzy?sap-client=300', params),
			// 销售拣货单号查询
			sapSchDn: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_dn?sap-client=300', params),
			// 销售拣货单
			sapPickingDn: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/picking_dn?sap-client=300', params),
			// 销售拣货过账
			sapDelv: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/post_delv?sap-client=300', params),
			// 销售拣货查询bl pl
			sapBlpl: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_BLPL?sap-client=300', params),
			// 查询仓位
			sapLgpla: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_LGPLA?sap-client=300', params),
			// 装箱
			sapCasePlnr: (params = {}) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_case/pda_case_plnr?sap-client=300', params),
		},
		mesApi:{
			//生产领料
			pdaMaterialcreate: (params = {}) => vm.$u.get(config.adminPath + 'apiPda/material/pdaMaterialcreate', params),
		}
    };

}

export default {
    install
}
