import { mapState } from 'vuex'
import store from "@/store"

// 尝试将用户在根目录中的store/index.js的vuex的state变量，全部加载到全局变量中
let $uStoreKey = [];
try{
	$uStoreKey = store.state ? Object.keys(store.state) : [];
}catch(e){
	
}

module.exports = {
	beforeCreate() {
		// 将vuex方法挂在到$u中
		// 使用方法为：如果要修改vuex的state中的user.name变量为"史诗" => this.$u.vuex('user.name', '史诗')
		// 如果要修改vuex的state的version变量为1.0.1 => this.$u.vuex('version', '1.0.1')
		this.$u.vuex = (name, value) => {
			this.$store.commit('$uStore', {
				name,value
			})
		}
	},
	computed: {
		// 将vuex的state中的所有变量，解构到全局混入的mixin中
		...mapState($uStoreKey)
	},
	methods: {
		//返回指定页面
		goMypage(url){
			let pages = getCurrentPages(); 
			//函数用于获取当前页面栈的实例，以数组形式按栈的顺序给出，第一个元素为首页，最后一个元素为当前页面
			var num=pages.length
			//当前页面栈总数
			var backnum
			//需要返回的页数
			for(var i =0;i<num;i++){
				console.log(pages[i].route)
				//循环找到指定页面路由所在的页数
				if(pages[i].route==url){
					backnum=num-i-1
					//计算返回的层数，总数-指定页面页数-1
				}		
			}
			uni.navigateBack({
				delta:backnum
				//返回的页面数，如果 delta 大于现有页面数，则返回到首页。
			})
		}
	}
}