/**
 * Copyright (c) 2013-Now http://aidex.vip All rights reserved.
 */
// 此处第二个参数vm，就是我们在页面使用的this，你可以通过vm获取vuex等操作
const install = (Vue, vm) => {

    // 参数配置对象
    const config = vm.vuex_config;
	// sap-client
	const sapClient = 300;
	

    // 将各个定义的接口名称，统一放进对象挂载到vm.$u.api(因为vm就是this，也即this.$u.api)下
    vm.$u.api = {

        // 基础服务：登录登出、身份信息、菜单授权、切换系统、字典数据等
        lang: (params = {}) => vm.$u.get('/lang/' + params.lang),
        index: (params = {}) => vm.$u.get(config.adminPath + '/mobile/index', params),
        getUserInfo: (params = {}) => vm.$u.get(config.adminPath + '/mobile/user/getUserInfo', params),
        login: (params = {}) => vm.$u.post('/mobile/login/loginByPassword', params),
        sendCode: (params = {}) => vm.$u.post(config.adminPath + '/mobile/login/sendCode', params),
        registerUser: (params = {}) => vm.$u.post(config.adminPath + '/mobile/user/registerUser', params),

        // 个人信息修改
        user: {
            saveUserInfo: (params = {}) => vm.$u.post(config.adminPath + '/mobile/user/saveUserInfo', params),
            infoSavePwd: (params = {}) => vm.$u.put(config.adminPath + '/system/user/profile/updatePwd',
                params),
            infoSavePqa: (params = {}) => vm.$u.post(config.adminPath + '/sys/user/infoSavePqa', params),
        },

        // 员工用户查询
        empUser: {
            listData: (params = {}) => vm.$u.get(config.adminPath + '/sys/empUser/listData', params),
        },
		sapApi: {
			// 采购入库
			sapRrm: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/cud_mm_rrm/rrm?sap-language=ZH&sap-client=' + client, params),
			sapPlnr: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/get_mm_plnr/plnr?sap-language=ZH&sap-client=' + client, params,),
			// 仓位转移
			sapDict: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/ep_dict?sap-language=ZH&sap-client=' + client, params),
			// 生产领料
			sapProiss: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_plto_proiss?sap-language=ZH&sap-client=' + client, params),
			// 完工入库
			sapOrder: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/PDA_MES_Order/PDA_ORDER?sap-language=ZH&sap-client=' + client, params),
			// 线边库转移下架
			sapXbkzy: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_plto_xbkzy?sap-language=ZH&sap-client=' + client, params),
			// 销售拣货单号查询
			sapSchDn: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_dn?sap-language=ZH&sap-client=' + client, params),
			// 销售拣货单
			sapPickingDn: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/picking_dn?sap-language=ZH&sap-client=' + client, params),
			// 销售拣货过账
			sapDelv: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/post_delv?sap-language=ZH&sap-client=' + client, params),
			// 销售拣货查询bl pl
			sapBlpl: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_BLPL?sap-language=ZH&sap-client=' + client, params),
			// 查询仓位
			sapLgpla: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_LGPLA?sap-language=ZH&sap-client=' + client, params),
			// 装箱
			sapCasePlnr: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_case/pda_case_plnr?sap-language=ZH&sap-client=' + client, params),
			sapCasePlnr2: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_case/pda_case_plnr2?sap-language=ZH&sap-client=' + client, params),
			// 待盘点
			sapInventory: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/search/sch_inventory?sap-language=ZH&sap-client='+ client, params),
			// 回传盘点结果
			postInventory: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/post_inventory?sap-client='+ client, params),
			// 工厂调拨查询
			sapSearchAllot: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/pda_allot/search_allot?sap-language=ZH&sap-client='+ client, params),
			// 工厂调拨下架
			sapAllot: (params = {}, client = sapClient) => vm.$u.post(config.adminPath + '/sap/bc/erp_ep/PDA_ALLOT_PD/ALLOT_PD?sap-language=ZH&sap-client='+ client, params),

		},
		mesApi:{
			//生产领料查询单号
			pdaMaterialcreate: (params = {}) => vm.$u.get(config.adminPath + 'apiPda/material/pdaMaterialcreate', params),
			// 调拨料申请查询
			pdaAllocationCreate: (params = {}) => vm.$u.get(config.adminPath + 'apiPda/allocation/pdaAllocationCreate', params),
			// 生产退料查询单号
			pdaMaterialReturn: (params = {}) => vm.$u.get(config.adminPath + '/apiPad/materialReturn/pdaMaterialReturn', params),
			//生产领料
			pdaSapissuecreate: (params = {}) => vm.$u.post(config.adminPath + '/apiPda/issue/pdaissuecreate', params),
			// 生产退料
			pdaMaterialReturnNum: (params = {}) => vm.$u.post(config.adminPath + '/apiPad/materialReturn/pdaMaterialReturnNum', params),
			// 完工入库
			pdaFindPackageLinkInfo: (params = {}) => vm.$u.post(config.adminPath + '/apiPda/search/findPackageLinkInfo', params),
			// 调拨料回传mes
			pdaAllocation: (params = {}) => vm.$u.post(config.adminPath + '/apiPda/allocation/pdaAllocation', params)
		}
    };

}

export default {
    install
}
