/**
 * Copyright (c) 2013-Now http://aidex.vip All rights reserved.
 */
// 此处第二个参数vm，就是我们在页面使用的this，你可以通过vm获取vuex等操作
const install = (Vue, vm) => {

    // 参数配置对象
    const config = vm.vuex_config;
	console.log(config);


    // 将各个定义的接口名称，统一放进对象挂载到vm.$u.api(因为vm就是this，也即this.$u.api)下
    vm.$u.api = {
        // 基础服务：登录登出、身份信息、菜单授权、切换系统、字典数据等
        login: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/login', params),
        getExAccountInfoApi: (params = {}) => vm.$u.postJson(config.adminPath + '/common/getExAccountInfo', params),
        changepassword: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/cmsmv/changepassword', params),
		// 到货条码打印查询
        getforprint: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purcc/getforprint', params),
		// 到货条码打印
        purccprint: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purcc/print', params),
		// 到货检验查询
		getforcheck: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purcc/getforcheck', params),
		// 到货检验确认
        purcccheck: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purcc/check', params),
        // 查询进货单创建列表
        getforcreate: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purtg/getforcreate', params),
        // 创建进货单
        purtgcreate: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/purtg/create', params),
        // 委外进货打印查询
        mocthgetforprint: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/getforprint', params),
		// 委外进货打印
        mocthprint: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/print', params),
        // 委外检验查询
		mocthgetforcheck: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/getforcheck', params),
		// 委外检验确认
        mocthcheck: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/check', params),
        // 委外扫码上架
		mocthgetforputon: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/getforputon', params),
		// 委外扫码上架
        mocthputon: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/mocth/puton', params),
        // 领料单查询
		moctcgetforcreate: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/moctc/getforcreate', params),
		// 领料单创建
        moctccreate: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/moctc/create', params),
        // 品号信息
        getforinvmbinfo: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/invmb/getforinvmbinfo', params),
        // 入库单创建
        createforstorage: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/moctf/createByErp', params),
        stockSaleOutList: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockSaleOut/list', params),
        stockList: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockSaleOut/stockList', params),
        confirmStock: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockSaleOut/confirm', params),
        getforinvmlinfo: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/invml/getforinvmlinfo', params),
        validateArrival: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockArrival/validate', params),
        confirmArrival: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockArrival/confirm', params),
        warehouseList: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/warehouseArrive/list', params),
		// 查询产品库存
		getforinvmlinfoApi: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/invml/getforinvmlinfo', params),
		// 新增库存交易单
		stockConfirmApi: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockTaking/confirm', params),
		// 调拨确认
		transferConfirmApi: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/stockAllocate/confirm', params),
		// 仓库查询
		getWarehouseListApi: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/cmsmc/getCmsmcList', params),
		// 库位查询
		getStorageListApi: (params = {}) => vm.$u.postJson(vm.vuex_api_url + '/cmsni/getCmsniList', params),
    };

}


export default {
    install
}
