
const mockData = {
    bls: [
        {
            "ZCODE": "BL24070000041",
            "PLNR": "10000820240402000001|10000320004",
            "WERKS": "1000",
            "KUNNR": "",
            "ZZXFS": "BL+PL",
            "ZSTATUS": "N",
            "ZXSPE": "56*41*32",
            "ZXVOLUM": 0.073,
            "ZXNTGEW": 1.250,
            "NTGEW": 20.750,
            "BRGEW": 22.000,
            "ZXTEXT": "",
            "ZTEXT": "",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "TS-LIUQI",
            "DATUM": "20240709",
            "UZEIT": "084744",
            "MNAME": "",
            "MDATE": "00000000",
            "MTIME": "000000",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        },
        {
            "ZCODE": "BL24070000041",
            "PLNR": "10000820240402000003|10000320003",
            "WERKS": "1000",
            "KUNNR": "",
            "ZZXFS": "BL+PL",
            "ZSTATUS": "N",
            "ZXSPE": "56*41*32",
            "ZXVOLUM": 0.073,
            "ZXNTGEW": 1.250,
            "NTGEW": 20.750,
            "BRGEW": 22.000,
            "ZXTEXT": "",
            "ZTEXT": "",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "TS-LIUQI",
            "DATUM": "20240709",
            "UZEIT": "084744",
            "MNAME": "",
            "MDATE": "00000000",
            "MTIME": "000000",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        },
        {
            "ZCODE": "BL24060000034",
            "PLNR": "PL16",
            "WERKS": "1000",
            "KUNNR": "0000600009",
            "ZZXFS": "BL+PL",
            "ZSTATUS": "N",
            "ZXSPE": "10*10*10",
            "ZXVOLUM": 0.001,
            "ZXNTGEW": 1.000,
            "NTGEW": 10.000,
            "BRGEW": 11.000,
            "ZXTEXT": "123",
            "ZTEXT": "321",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "admin",
            "DATUM": "20240621",
            "UZEIT": "195225",
            "MNAME": "CHENWL",
            "MDATE": "20240708",
            "MTIME": "174601",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        },
        {
            "ZCODE": "BL24060000034",
            "PLNR": "PL17",
            "WERKS": "1000",
            "KUNNR": "0000600009",
            "ZZXFS": "BL+PL",
            "ZSTATUS": "N",
            "ZXSPE": "10*10*10",
            "ZXVOLUM": 0.001,
            "ZXNTGEW": 1.000,
            "NTGEW": 10.000,
            "BRGEW": 11.000,
            "ZXTEXT": "123",
            "ZTEXT": "321",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "admin",
            "DATUM": "20240621",
            "UZEIT": "195225",
            "MNAME": "CHENWL",
            "MDATE": "20240708",
            "MTIME": "174601",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        }
    ],
    pls: [
        {
            "ZCODE": "BL24070000085",
            "PLNR": "PL0006000400001000000455021",
            "WERKS": "1000",
            "KUNNR": "0000600247",
            "ZZXFS": "PL",
            "ZSTATUS": "N",
            "ZXSPE": "56*41*32",
            "ZXVOLUM": 0.073,
            "ZXNTGEW": 1.250,
            "NTGEW": 48.750,
            "BRGEW": 50.000,
            "ZXTEXT": "",
            "ZTEXT": "",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "admin",
            "DATUM": "20240709",
            "UZEIT": "162212",
            "MNAME": "TS-LIUQI",
            "MDATE": "20240726",
            "MTIME": "154440",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        },
        {
            "ZCODE": "BL24070000072",
            "PLNR": "10000001240424000004|10000000002",
            "WERKS": "1000",
            "KUNNR": "0000600005",
            "ZZXFS": "PL",
            "ZSTATUS": "N",
            "ZXSPE": "56*41*32",
            "ZXVOLUM": 0.073,
            "ZXNTGEW": 1.250,
            "NTGEW": 20.750,
            "BRGEW": 22.000,
            "ZXTEXT": "",
            "ZTEXT": "",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "TS-LIUQI",
            "DATUM": "20240709",
            "UZEIT": "084744",
            "MNAME": "",
            "MDATE": "00000000",
            "MTIME": "000000",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        },
        {
            "ZCODE": "BL24070000071",
            "PLNR": "10000001240424000004|10000000001",
            "WERKS": "1000",
            "KUNNR": "0000600005",
            "ZZXFS": "PL",
            "ZSTATUS": "N",
            "ZXSPE": "56*41*32",
            "ZXVOLUM": 0.073,
            "ZXNTGEW": 1.250,
            "NTGEW": 20.750,
            "BRGEW": 22.000,
            "ZXTEXT": "",
            "ZTEXT": "",
            "ZIFSHMARK": "Y",
            "VBELN": "",
            "UNAME": "TS-LIUQI",
            "DATUM": "20240709",
            "UZEIT": "084744",
            "MNAME": "",
            "MDATE": "00000000",
            "MTIME": "000000",
            "AUNAME": "",
            "AUDATE": "00000000",
            "AUTIME": "000000"
        }
    ]
}

/**
 * 模拟查询PL和BL
 * @param {*} val 
 * @param {*} type false：PL， true：BL
 */
export const requestMock = (val, type = false) => {
    const datas = mockData[type ? 'bls' : 'pls']
    return datas.filter(item => {
        if (type) {
            return item.ZCODE == val
        }
        return item.PLNR == val
    })
}