/**
 * Copyright (c) 2013-Now http://aidex.vip All rights reserved.
 */
// 此处第二个参数vm，就是我们在页面使用的this，你可以通过vm获取vuex等操作
const install = (Vue, vm) => {

    // 参数配置对象
    const config = vm.vuex_config;

    // 将各个定义的接口名称，统一放进对象挂载到vm.$u.api(因为vm就是this，也即this.$u.api)下
    vm.$u.api = {
      // 基础服务：登录登出、身份信息、菜单授权、切换系统、字典数据等
      lang: (params = {}) => vm.$u.get('/lang/' + params.lang),
      index: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/index', params),
      getUserInfo: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/user/getUserInfo', params),
      getUserList: (params = {}) =>
        vm.$u.get(config.adminPath + '/system/user/list', params),
      getUserPrintInfo: () =>
        vm.$u.get(config.adminPath + '/system/print/printer'),
      getQcIndexList: (params) =>
        vm.$u.get(config.adminPath + '/mes/qc/qcindex/list', params),
      getPrintDown: (params) =>
        vm.$u.postJson(config.adminPath + '/common/printDown', params),
      login: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/login/loginByPassword', params),
      sendCode: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/login/sendCode', params),
      registerUser: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/user/registerUser', params),
			getCurrentsys: (params = {}) =>
			  vm.$u.get(
			    config.adminPath + '/md/appconfig/getVersion'
			  ),
      /**
       * 系统设置API
       */
      //获取工序清单
      getProcessList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/pro/process/getProcessList',
          params
        ),
      //获取工作单元列表
      getMesWorkunitList: (params = {}) =>
        vm.$u.get(config.adminPath + '/md/workunit/list', params),
      getWorkstationList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/md/workstation/getWorkstationList',
          params
        ),
      getWorkUnitList: (params = {}) =>
        vm.$u.get(config.adminPath + '/md/workunit/getListByUser', params),
      /**
       * 生产管理相关API
       **/
      //获取当前工作中心的生产任务
      getTaskList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/pro/protask/getTaskList', params),
      //根据任务ID获取任务详情
      getTaskInfo: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/pro/protask/' + params.taskId),
      //修改任务状态
      changeStatus: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/pro/protask/change', params),
      //开始任务加提示
      changeCheckMachineTool: (params = {}) =>
        vm.$u.get(
          config.adminPath +
            `/mes/pro/protask/getToolInProcess/${params.taskWorkunitId}`
        ),
      //生产报工
      feedback: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/pro/protask/feedback', params),
      //生产报工feedBackPackage
      feedBackPackage: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/protask/feedBackPackage',
          params
        ),
      // 生产指令列表
      workOrderSoDirectiveApi: (params = {}) =>
        vm.$u.postJson(
          config.adminPath + '/mobile/pro/protask/listFeedBackPackage',
          params
        ),
      //增加检验
      getTaskInfoByTaskCode: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/pro/protask/getProTaskByTaskCode',
          params
        ),
			getQcCondition: (params = {}) =>
			  vm.$u.postJson(
			    config.adminPath + '/mes/pro/workorder/getQcCondition',
			    params
			  ),
			generateItems: (params = {}) =>
			  vm.$u.postJson(
			    config.adminPath + '/mes/qc/templateindex/generateItems',
			    params
			  ),
			getWorkorder: (params = {}) =>
			  vm.$u.get(
			    config.adminPath + '/mes/pro/workorder/getWorkorder',
			    params
			  ),
      //
      getIpqcCode: (params = {}) =>
        vm.$u.get(config.adminPath + '/system/autocode/get/IPQC_CODE', params),

      //查看人员管理
      userQuery: (params = {}) =>
        vm.$u.get(config.adminPath + '/mes/md/workstationworker/list', params),

      //增加缺陷记录
      addDefectrecord: (params = {}) =>
        vm.$u.putJson(config.adminPath + '/mes/qc/defectrecord', params),
      //查询缺陷列表
      getDefectrecordList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mes/qc/defectrecord/list', params),
      //查询检测项
      getIpqcLineList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mes/qc/ipqcline/list', params),
      //生产日志
      productionLogList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/pro/productionlog/list', params),
      //增加生产日志
      addProductionlog: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/pro/productionlog/add', params),
      //增加生产物料扣减
      addMaterialusagerecord: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/materialusagerecord',
          params
        ),
      //生产物料扣减列表
      materialusagerecordList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/pro/materialusagerecord/list',
          params
        ),
      //查询检验列表
      ipqcList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mes/qc/ipqc/list', params),
      //增加检验
      addIpqc: (params = {}, type = 'postJson') =>
        vm.$u[type](config.adminPath + '/mes/qc/ipqc', params),
      //切换检验单状态
      changeState: (params = {}) =>
        vm.$u.postJson(config.adminPath + '/mes/qc/ipqc/changeState', params),
      //根据字典类型查询字典数据信息
      getDicts: (params = {}) =>
        vm.$u.get(config.adminPath + '/system/dict/data/type/' + params),

      //根据字典类型查询字典数据信息
      getIssusLinebyWorkorderCodes: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/wm/issueline/listByWorkorderCodes',
          params
        ),


      /**
       * 工艺工序相关API
       */
      getProcessInfo: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/pro/process/' + params.processId),
      //获取当前产品的SOP
      getSopList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/pro/taskissue/getSopList',
          params
        ),
      //生产投料
      addIssue: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/pro/taskissue/add', params),
      //整个领料单投料
      addholeIssue: (params = {}) =>
        vm.$u.post(config.adminPath + '/mobile/pro/taskissue/addIssue', params),
      //删除投料信息
      removeTaskIssue: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/taskissue/' + params.recordId
        ),
      //获取当前工作中心、当前生产任务对应的投料清单
      getTaskIssueList: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/pro/taskissue/getlist', params),
      //查询可用的领料单
      getReserveIssue: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/pro/taskissue/getReserveIssueList',
          params
        ),
      //人员绑定打印机
      getUserPrint: (params = {}) =>
        vm.$u.get(config.adminPath + '/system/printerConfig/userList', params),
      addUserPrint: (params = {}) =>
        vm.$u.postJson(config.adminPath + '/system/print', params),

      //投料验证
      listFeedingInspection: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/proMaterial/listIssueLine',
          params
        ),
      validateFeedingInspection: (params = {}) =>
        vm.$u.post(
          config.adminPath +
            '/mobile/pro/proMaterial/validateFeedingInspection',
          params
        ),
      validateFeedingInspectionById: (params = {}) =>
        vm.$u.post(
          config.adminPath +
            '/mobile/pro/proMaterial/validateFeedingInspectionById',
          params
        ),

      //查询反冲料列表
      recoilMaterialList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/pro/recoilMaterial/getRecoilMaterialList',
          params
        ),
      //增加反冲料
      addRecoilMaterial: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/proMaterial/addRecoilMaterial',
          params
        ),
      //删除反冲料
      deleteRecoilMaterial: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/proMaterial/deleteRecoilMaterial',
          params
        ),

      //领料申请
      listMaterialRequest: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/proMaterial/listMaterialRequest',
          params
        ),
      addMaterialRequest: (params = {}) =>
        vm.$u.postJson(
          config.adminPath + '/mobile/pro/proMaterial/addMaterialRequest',
          params
        ),
      getWproworkOrderProcessItem: (params = {}) =>
        vm.$u.postJson(
          config.adminPath + '/pro/materialRequest/selectworkorder',
          params
        ),

      //退料申请
      listMaterialReturn: (params = {}) =>
        vm.$u.post(
          config.adminPath + '/mobile/pro/proMaterial/listIssueLine',
          params
        ),
      addMaterialReturn: (params = {}) =>
        vm.$u.postJson(
          config.adminPath + '/mobile/pro/proMaterial/addMaterialReturn',
          params
        ),

      //质量相关api
      //获取当前产品、当前质检类型的质检模板行信息
      getQcTemplateLine: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/qc/templateindex/getLines',
          params
        ),

      //自动生成接口
      genCode: (ruleCode) => vm.$u.get(config.adminPath +
          '/system/autocode/get/' + ruleCode
      ),
	  
	   //获取最后一道工序
	  getNextProcess: (params = {}) =>
	  	    vm.$u.get(config.adminPath + '/mobile/pro/protask/feedBackNextProcess', params),


      //首页相关api
      getIndexCardInfo: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/index/getIndexCardInfo', params),
      getM2mOrderFlowList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/index/getM2mOrderFlowList',
          params
        ),
      //获取卡可购买套餐包
      getM2mOrderPackageList: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mobile/index/getM2mOrderPackageList',
          params
        ),

      //查看生产工单
      getWorkorder: (params = {}) =>
        vm.$u.get(config.adminPath + '/mes/pro/workorder/list', params),
      
      //查看生产工单
      getWorkorderWithSizeAndDirective: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/mes/pro/workorder/listWithSizeAndDirective',
          params
        ),

      logout: (params = {}) =>
        vm.$u.get(config.adminPath + '/mobile/login/logout', params),
      authInfo: (params = {}) =>
        vm.$u.get(config.adminPath + '/authInfo', params),
      menuTree: (params = {}) =>
        vm.$u.get(config.adminPath + '/menuTree', params),
      switchSys: (params = {}) =>
        vm.$u.get(config.adminPath + '/switch/' + params.sysCode),
      dictData: (params = {}) =>
        vm.$u.get(
          config.adminPath + '/system/dict/data/type/' + params.dictType
        ),

      // 账号服务：验证码接口、忘记密码接口、注册账号接口等
      validCode: (params = {}) => vm.$u.getText('/validCode', params),
      getFpValidCode: (params = {}) =>
        vm.$u.post('/account/getFpValidCode', params),
      savePwdByValidCode: (params = {}) =>
        vm.$u.post('/account/savePwdByValidCode', params),
      getRegValidCode: (params = {}) =>
        vm.$u.post('/account/getRegValidCode', params),
      saveRegByValidCode: (params = {}) =>
        vm.$u.post('/account/saveRegByValidCode', params),
      getPrintTemplateList: (params = {}) =>
        vm.$u.get(config.adminPath + '/ureportM/list', params),
      putProtaskSplit: (params = {}) =>
        vm.$u.putJson(config.adminPath + '/mes/pro/protask/split', params),
      // APP公共服务
      upgradeCheck: () =>
        vm.$u.post('/app/upgrade/check', {
          appCode: config.appCode,
          appVersion: config.appVersion,
        }),
      commentSave: (params = {}) => vm.$u.post('/app/comment/save', params),

      // 个人信息修改
      user: {
        saveUserInfo: (params = {}) =>
          vm.$u.post(config.adminPath + '/mobile/user/saveUserInfo', params),
        infoSavePwd: (params = {}) =>
          vm.$u.put(
            config.adminPath + '/system/user/profile/updatePwd',
            params
          ),
        infoSavePqa: (params = {}) =>
          vm.$u.post(config.adminPath + '/sys/user/infoSavePqa', params),
      },

      // 员工用户查询
      empUser: {
        listData: (params = {}) =>
          vm.$u.get(config.adminPath + '/sys/empUser/listData', params),
      },

      // 组织机构查询
      office: {
        treeData: (params = {}) =>
          vm.$u.get(config.adminPath + '/sys/office/treeData', params),
      },
      //查看异常模块信息
      abnormal: {
        detail: (params = {}) =>
          vm.$u.get(config.adminPath + '/qc/information/list', params),
        newlyAdd: (params = {}) =>
          vm.$u.postJson(config.adminPath + '/qc/report', params),
      },
      //查看图片
      viewpicture: {
        //查看工单
        viewWorkorder: (params = {}) =>
          vm.$u.get(
            config.adminPath + '/mobile/pro/protask/getProWorkder',
            params
          ),
        //查看图片
        viewSop: (params = {}) =>
          vm.$u.get(
            config.adminPath + '/mes/md/sop/getProWorkder/' + params.workorderId
          ),
        //查看规格书详情
        viewSpecificationSheetInfo: (params = {}) =>
          vm.$u.get(
            config.adminPath +
              '/pro/specificationSheet/info/' +
              params.workorderId
          ),
      },
			
      // 增删改查例子
      testData: {
        form: (params = {}) =>
          vm.$u.post(config.adminPath + '/test/testData/form', params),
        list: (params = {}) =>
          vm.$u.post(config.adminPath + '/test/testData/listData', params),
        save: (params = {}) =>
          vm.$u.postJson(config.adminPath + '/test/testData/save', params),
        disable: (params = {}) =>
          vm.$u.post(config.adminPath + '/test/testData/disable', params),
        enable: (params = {}) =>
          vm.$u.post(config.adminPath + '/test/testData/enable', params),
        delete: (params = {}) =>
          vm.$u.post(config.adminPath + '/test/testData/delete', params),
      },
      // 刀模版相关
      dModel: {
        // 获取领用单
        getToolsByProcessIdAndArrangeCode: (params = {}) =>
          vm.$u.putJson(
            config.adminPath +
              '/tm/tmToolRequestUse/getToolsByProcessIdAndArrangeCode',
            params
          ),
        // 获取上下机记录
        getRecordsByProcessIdAndArrangeCode: (params = {}) =>
          vm.$u.putJson(
            config.adminPath +
              '/tm/tmToolMachinesRecord/getRecordsByProcessIdAndArrangeCode',
            params
          ),
        // 新增
        //  http://192.168.3.91:8080/tm/tmToolMachines/scancode
        tmToolMachines: (params = {}) =>
          vm.$u.postJson(config.adminPath + '/tm/tmToolMachines', params),
        tmToolMachinesRecord: (params = {}) =>
          vm.$u.putJson(config.adminPath + '/tm/tmToolMachines', params),
        tmToolMachinesScancode: (params = {}) =>
          vm.$u.postJson(
            config.adminPath + '/tm/tmToolMachines/scancode',
            params
          ),
      },
    };

}

export default {
    install
}
