// import Vue from 'vue'
import DataDict from '@/common/dict'
// import http from '@/common/http.api'

const cache = {}; // 用于缓存已请求的字典数据

const install = (Vue, vm) => {

    Vue.use(DataDict, {
        metas: {
            '*': {
                labelField: 'dictLabel',
                valueField: 'dictValue',
                request(dictMeta) {
                    if (cache[dictMeta.type]) {
                        return Promise.resolve(cache[dictMeta.type]);
                    } else {
                        // return vm.$u.api.getDicts(dictMeta.type).then(res => res.data)
                        return vm.$u.api.getDicts(dictMeta.type).then(res => {
                            cache[dictMeta.type] = res.data;
                            return res.data;
                        });
                    }
                },
            },
        },
    })
}
const logout = () => {
    Object.keys(cache).forEach(key => delete cache[key]);
};

export default {
    install,
    logout
}
