var tsc = require('./tsc.js')
import bluetoothTool from './BluetoothTool.js'
export default {
    data () {
      return {
        devices: [],
        currDev: null,
        connId: '',
        first:true,
        tableDomId: '',
        tableImgPath: '',
        canvasWidth: 800,
        canvasHeight: 600
      }
    },
    created () {
        //#ifdef APP-PLUS
        // 蓝牙
        bluetoothTool.init({
            listenBTStatusCallback: (state)=> {
                // if(state == 'STATE_ON') {
                //     let lastBleAddress = uni.getStorageSync('lastBleAddress')
                //     if(lastBleAddress) {
                //         uni.showLoading({
                //             title: '正在连接...'
                //         })
                //         console.log(lastBleAddress)
                //         bluetoothTool.connDevice(lastBleAddress,(result)=>{
                //             uni.hideLoading()
                //             uni.showToast({
                //                 title: result?'连接成功！':'连接失败...'
                //             });
                //         })
                //     }
                // }
            },
            discoveryDeviceCallback: this.onDevice,
            discoveryFinishedCallback: function() {
                console.log('搜索到的设备', that.devices)
            },
            readDataCallback: function(dataByteArr) {
                /* if(that.receiveDataArr.length >= 200) {
                    that.receiveDataArr = [];
                }
                that.receiveDataArr.push.apply(that.receiveDataArr, dataByteArr); */
            },
            connExceptionCallback: function(e) {
                console.log(e);
                that.msg = "设备连接失败";
            }
        });
        this.searchBle()
        //#endif
    },
    computed: {
     
    },
    methods: {
        searchBle() {
            var that = this
            console.log("initBule")
            // 使用openBluetoothAdapter 接口，免去主动申请权限的麻烦
            uni.openBluetoothAdapter({
                success(res) {
                    this.devices = []
                    console.log("打开 蓝牙模块，开始搜索模式...")
                    console.log(res)
                    bluetoothTool.discoveryNewDevice();
                    //that.onDevice()
                }
            })
        },
        onDevice(newDevice){
            console.log("监听寻找到新设备的事件---------------")
            console.log(newDevice)
            if(newDevice.name && newDevice.name != 'null') {
                this.devices.push({
                    name: newDevice.name,
                    address: newDevice.address
                })
                if (newDevice.name === 'CT-428D' && this.first) {
                    this.onConn(newDevice)
                    this.first = false
                }
            }
        },
        onConn(item) {
            console.log("连接蓝牙---------------" + item.address)
            /* uni.showLoading({
                title: '连接中',
                mask: false
            }); */
            
            bluetoothTool.connDevice(item.address,(result)=>{
                if(result) {
                    uni.setStorageSync('lastBleAddress', item.address)
                }
                console.log('连接结果：',result)
            });
        },
        print (filePath) {
            const firstCanvas = uni.createCanvasContext('firstCanvas', this);
            const that = this
            uni.getImageInfo({
                src: filePath,
                success(res) {
                    that.canvasWidth = 800
                    that.canvasHeight = 640
                    console.log(res, that.canvasWidth, that.canvasHeight)
                    firstCanvas.drawImage(filePath, 0, 0, that.canvasWidth, that.canvasHeight);
                    firstCanvas.draw();
                    that.$nextTick(() => { //获取画布像素数据
                        uni.canvasGetImageData({
                            canvasId: 'firstCanvas',
                            x: 0,
                            y: 0,
                            width: that.canvasWidth,
                            height: that.canvasHeight,
                            success: (res)=> {
                                var command = tsc.jpPrinter.createNew()
                                command.init()
                                command.setSize(100, 80)
                                command.setGap(2)
                                command.setCls()
                                command.setBitmap2(0, 0, 0, res)
                                command.setPagePrint()
                                console.log('数据发送： \n',command.getRawData())
                                let data = command.getData()
                                console.log('data', data)
                                bluetoothTool.sendByteData(data)
                                console.log('发送完毕')
                            },
                            fail: function(res) {
                                console.log(res)
                            }
                        })
                    })
                },
                fail(res) {
                    console.log(res)
                }
            })
        },
    }
}