import i18n from '../lang/index'
import config from './config.js'
function check(param = {}) {

    // 合并默认参数
    param = Object.assign({
        title: i18n.t('检测到有新版本！'),
        content: i18n.t('请升级app到最新版本！'),
        canceltext: i18n.t('暂不升级'),
        oktext: i18n.t('立即升级')
    }, param)
    plus.runtime.getProperty(plus.runtime.appid, (widgetInfo) => {
        let platform = plus.os.name.toLocaleLowerCase()
				try {
					console.log(widgetInfo.version)
					uni.request({
						url: config.baseUrl + '/md/appconfig/getVersion?appName=mesPad',
						success: (result) => {
							result = result.data
							console.log('result', result)
							    let data = result.data ? result.data[0] : null;
									console.log(widgetInfo.version, data.version)
							    if (widgetInfo.version === data.version) {
							        return;
							    }
							    if (result.code == 200) {
							        // android进行如下操作
							        uni.showModal({
							            title: param.title,
							            content: data.updateDesc ? data.updateDesc + '' : param.content,
							            showCancel: false,
							            confirmText: param.oktext,
							            cancelText: param.canceltext,
							            success: res => {
							                if (!res.confirm) {
							                    console.log('取消了升级');
							                    plus.runtime.quit();
							                }
							
							                    // 清除缓存
							                    // request.clearLogin();
							
							
							                    // 开始下载
							                    // 创建下载任务
							                    var dtask = plus.downloader.createDownload(data.url, {
							                            filename: "_downloads/"
							                        },
							                        function (d, status) {
							                            // 下载完成
							                            if (status == 200) {
							                                plus.runtime.install(d.filename, {
							                                    force: true
							                                }, function () {
							                                    //进行重新启动;
							                                    plus.runtime.restart();
							                                }, (e) => {
							                                    uni.showToast({
							                                        title: i18n.t('安装升级包失败:') + JSON
							                                            .stringify(e),
							                                        icon: 'none'
							                                    })
							                                });
							                            } else {
							                                this.tui.toast(i18n.t('下载升级包失败，请手动去站点下载安装，错误码:') +
							                                    status);
							                            }
							                        });
							
							                    let view = new plus.nativeObj.View("maskView", {
							                        backgroundColor: "rgba(0,0,0,.6)",
							                        left: '0px',
							                        bottom: "0px",
							                        width: plus.screen.resolutionWidth,
							                        height: plus.screen.resolutionHeight
							                    })
							
							                    view.drawText(i18n.t('开始下载'), {}, {
							                        size: '12px',
							                        color: '#FFFFFF'
							                    });
							
							                    view.show()
							
							
							                    dtask.addEventListener("statechanged", (e) => {
							                        if (e && e.downloadedSize > 0) {
							                            let jindu = ((e.downloadedSize / e.totalSize) *
							                                100).toFixed(2)
							                            view.reset();
							                            view.drawText(i18n.t('进度:') + jindu + '%', {}, {
							                                size: '12px',
							                                color: '#FFFFFF'
							                            });
							                        }
							                    }, false);
							                    dtask.start();
							            }
							        })
							    }
						}
					})
				} catch (e) {
					console.log('eee',e)
				}
		});
}

export default {
    check
}
