// @ts-ignore
/* eslint-disable */
import { graphql } from '../api';

const gqlStringAllWorkUnit = `query{workUnit(specification:{stationType:{id:{_v:eq,_val:"2"}}},sort:{orders:[{pty:"name",dir:asc}]}){id,name,description,picName,workCenter{id,name, description,workSite{id,name, description,}}}}`;
const gqlStringWorkUnitByWorkSiteId = (worksiteId: string) =>
  `query{workUnit(specification: {workCenter:{workSite:{id:{_v: eq, _val: "${worksiteId}"}}}}){id,name,description,workCenter{id,name, description,workSite{id,name, description,}}}}`;
const gqlStringAllWorkSite = `query{workSite(sort:{orders:[{pty:"name",dir:asc}]}){id,name,description}}`;

export async function getAllWorkUnit(options?: { [key: string]: any }) {
  const graphqlParams = {
    operationName: null,
    variables: {},
    query: gqlStringAllWorkUnit,
  };
  var graphqlResult = await graphql(graphqlParams);
  return graphqlResult.data.workUnit as API.WorkUnit[];
}

export async function getWorkUnitByWorkSiteId(
  worksiteId: string,
  options?: { [key: string]: any },
) {
  const graphqlParams = {
    operationName: null,
    variables: {},
    query: gqlStringWorkUnitByWorkSiteId(worksiteId),
  };
  var graphqlResult = await graphql(graphqlParams);
  return graphqlResult.data.workUnit as API.WorkUnit[];
}

export async function getWorkUnitByIfWorkSiteId(
  worksiteId?: string,
  options?: { [key: string]: any },
) {
  if (worksiteId && worksiteId.length > 0) {
    return await getWorkUnitByWorkSiteId(worksiteId, options);
  }
  return await getAllWorkUnit(options);
}

export async function getAllWorkSite(options?: { [key: string]: any }) {
  const graphqlParams = {
    operationName: null,
    variables: {},
    query: gqlStringAllWorkSite,
  };
  var graphqlResult = await graphql(graphqlParams);
  return graphqlResult.data.workSite as API.WorkSite[];
}
