import { request } from 'umi';
import { graphql } from '@/services/common';

type ProcessFailQualityErrorDto = KANBAN.QiPingComprehens.ProcessFailQualityErrorDto;
type MaterialReqOrderInfoDto = KANBAN.QiPingComprehens.MaterialReqOrderInfoDto;
type MaterialReqOrderInfoCriteria = KANBAN.QiPingComprehens.MaterialReqOrderInfoCriteria;
type EquipmentDetailCriteria = KANBAN.QiPingComprehens.EquipmentDetailCriteria;
type EquipmentDetailDto = KANBAN.QiPingComprehens.EquipmentDetailDto;
type EquipmentErrorDetailDto = KANBAN.QiPingComprehens.EquipmentErrorDetailDto;
type ProductionErrorDetailDto = KANBAN.QiPingComprehens.ProductionErrorDetailDto;
type AbnormalOverdueSettingDto = KANBAN.QiPingComprehens.AbnormalOverdueSettingDto;
type ErrorDetailCriteria = KANBAN.QiPingComprehens.ErrorDetailCriteria;
type QualityDetailDto = KANBAN.QiPingComprehens.QualityDetailDto;
type QiPingComprehensKanbanDataDto = KANBAN.QiPingComprehens.QiPingComprehensKanbanDataDto;
type ProcessYieldData = KANBAN.QiPingComprehens.ProcessYieldData;
type ProcessDefectRatioData = KANBAN.QiPingComprehens.ProcessDefectRatioData;
type WorkOrderMonthlyIndexData = KANBAN.QiPingComprehens.WorkOrderMonthlyIndexData;
type ComprehensiveDeviceEcpDataCount = KANBAN.QiPingComprehens.ComprehensiveDeviceEcpDataCount;
type ComprehensiveDataCount = KANBAN.QiPingComprehens.ComprehensiveDataCount;
type CountWeldingPassRate = KANBAN.QiPingComprehens.CountWeldingPassRate;
type PassRateTrendChart = KANBAN.QiPingComprehens.PassRateTrendChart;
type BatchInfoDto = KANBAN.QiPingComprehens.BatchInfoDto;

type ProcessOutputParams = {
  kanbanSettingId: string;
  planSource: number;
  dataRange: number;
};

export async function queryProductionComprehensKanbanData() {
  return request<Api.ServiceResult<QiPingComprehensKanbanDataDto[]>>(
    '/api/qiPingComprehensiveKanbanSetting/list',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}

export async function queryProductionComprehensProcessOutputData(body: ProcessOutputParams) {
  return request<Api.ServiceResult<ProcessYieldData[]>>('/processYieldData1/kanbanData', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
  });
}
export async function queryProcessDefectRatioData(body: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<ProcessDefectRatioData[]>>(
    '/api/processDefectRatioData/kanbanData',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
export async function queryWorkOrderMonthlyIndexData1(body: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<WorkOrderMonthlyIndexData>>(
    '/api/workOrderMonthlyIndexData1/kanbanData',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
// 设备异常
export async function queryComprehensiveDeviceEcpData(body: { settingId: string }) {
  return request<Api.ServiceResult<ComprehensiveDeviceEcpDataCount>>(
    '/api/comprehensiveDeviceEcpData/count',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params: body,
    },
  );
}
// 生产异常
export async function queryComprehensiveProdEcpData(body: { settingId: string }) {
  return request<Api.ServiceResult<ComprehensiveDataCount>>('/comprehensiveProdEcpData/count', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    params: body,
  });
}
// 质量异常
export async function queryComprehensiveQualityEcpData(body: { settingId: string }) {
  return request<Api.ServiceResult<ComprehensiveDataCount>>(
    '/api/comprehensiveQualityEcpData/count',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params: body,
    },
  );
}
// 焊接通过率
export async function queryCountWeldingPassRate(body: { settingId: string }) {
  return request<Api.ServiceResult<CountWeldingPassRate>>('/batchInfo/countWeldingPassRate', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    params: body,
  });
}
// 焊接通过率趋势图
export async function queryCountWeldingPassRateTrendChart(data: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<PassRateTrendChart[]>>(
    '/api/batchInfo/countWeldingPassRateTrendChart',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 工序一次未通过率趋势图
export async function queryPunctualityPenetratingByKanban(data: {
  kanbanSettingId: string;
  processName: string;
  boardType: number;
}) {
  return request<Api.ServiceResult<PassRateTrendChart[]>>(
    '/api/processDefectRatioData/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 工序一次未通过关联质量异常
export async function queryProcessFailQualityError(data: {
  kanbanSettingId: string;
  processName: string;
  boardType: number;
}) {
  return request<Api.ServiceResult<ProcessFailQualityErrorDto[]>>(
    '/api/processDefectRatioData/listQualityError',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

// 质量异常明细
export async function queryQualityDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<QualityDetailDto>>>(
    '/api/Kanban/GetExceptionInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 设备异常明细
export async function queryEquipmentErrorDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<EquipmentErrorDetailDto>>>(
    '/api/Kanban/GetDEInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 生产异常明细
export async function queryProductionErrorDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<ProductionErrorDetailDto>>>(
    '/api/Kanban/GetPEInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 设备详情
export async function queryEquipmentDetail(body: EquipmentDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<EquipmentDetailDto>>>(
    '/api/Kanban/GetDeviceInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 领料单
export async function queryMaterialReqOrderInfo(body: MaterialReqOrderInfoCriteria) {
  return request<Api.ServiceResult<Api.PageResult<MaterialReqOrderInfoDto>>>(
    '/api/Kanban/GetMaterialReqOrderInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 获取全局配置异常超期天数
export async function findAbnormalOverdueSetting(options?: { [p: string]: any }) {
  const specification: string[] = [];
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            abnormalOverdueSetting(
              specification:${query},
              sort:{
                orders:[]
              }){
                werks,
                type{
                  id,name
                },
                overdueDays,
              }
            }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  console.log(result);
  return result.data.abnormalOverdueSetting as AbnormalOverdueSettingDto[];
}

// 领料单
export async function queryProcesspunctualityPenetrating(body) {
  return request<Api.ServiceResult<Api.PageResult<{ lotNos: string; currentProcessName: string }>>>(
    '/api/processYieldData1/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 工单明细
export async function queryPageByKanbanPenetrating(
  body: { kanbanSettingId: string; type: number } & Common.PageParams,
) {
  return request<Api.ServiceResult<Api.PageResult<BatchInfoDto[]>>>(
    '/api/batchInfo/pageByKanbanPenetrating',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 工单趋势数据
export async function queryBatchInfoPunctualityPenetrating(body: {
  kanbanSettingId: string;
  type: number;
  boardType: number;
}) {
  return request<Api.ServiceResult<Api.PageResult<{ period: string; val: number }[]>>>(
    '/api/batchInfo/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
// 工单年度计划量
export async function queryPlanQuantityPenetratingByKanban(body: {
  kanbanSettingId: string;
  boardType: number;
}) {
  return request<Api.ServiceResult<{ period: string; val: number }[]>>(
    '/api/batchInfo/planQuantityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
// 获取设备状态信息
export async function queryDeviceRunTimeEcp(data: { settingId: string }) {
  return request<Api.ServiceResult<{ device: string; isEcp: string; beyondHours: any }[]>>(
    '/api/comprehensiveDeviceEcpData/getDeviceRunTimeEcp',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params: data,
    },
  );
}
