import FactoryItem from './FactoryItem';
import { useEffect } from 'react';
import QualityAbnormal from './qualityAbnormal';
import DeviceAbnormal from './deviceAbnormal';
import DeviceCountTable from './deviceCount';
import styles from '../../index.less';
import { Modal } from 'antd';
import { useState } from 'react';
import { useIntl } from 'umi';
type EquipmentDetailCriteria = KANBAN.ProductionComprehens.EquipmentDetailCriteria;
type ErrorDetailSetting = KANBAN.ProductionComprehens.ErrorDetailSetting;

const Abnormal: React.FC<{
  abnormalProdData: any;
  abnormalQualityData: any;
  abnormalDeviceData: any;
  factoryLine: Array<any>;
  setting: ErrorDetailSetting;
}> = ({ abnormalProdData, abnormalQualityData, abnormalDeviceData, factoryLine, setting, }) => {
  const intl = useIntl();
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [criteria, setCriteria] = useState<EquipmentDetailCriteria>();
  const closeModal = () => setIsModalOpen(false);
  const openModal = (type: number) => {
    setIsModalOpen(true);
    setCriteria({
      workshopName: setting.workshopName || '',
      current: 1,
      pageSize: 10,
      status: type,
    });
  };
  let timer: NodeJS.Timer | null = null;
  const stopLoop = () => {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  };
  const startLoop = () => {
    stopLoop();
    let leftScroll = document.getElementById('leftScroll') as HTMLElement
    if (leftScroll) {
      timer = setInterval(() => {
        leftScroll.scrollTop += 60
        if (leftScroll.scrollTop + leftScroll.offsetHeight >= leftScroll.scrollHeight) {
          leftScroll.scrollTop = 0
        }
      }, setting.rowMovingTime * 1000)
    }
  };
  
  useEffect(() => {
    stopLoop()
    startLoop()
    return () => {
      stopLoop()
    }
  }, [setting]);
  return (
    <>
      <div className={styles.leftWrapper} id="leftScroll" onMouseOver={stopLoop}//移出关闭
      onMouseOut={startLoop}>
        {factoryLine.map((factory) => (
          <div className={styles.Factorycard} >
            <div>{factory.name}</div>
            <div className={styles.itemContainer} >
              <FactoryItem data={factory.arr} setting={setting} />
            </div>
          </div>
        ))}
      </div>
    </>
  );
};

export default Abnormal;
