import React from 'react';
import Machine from '../Machine';
import styles from './index.less';

type MachineCellProps = {
  machineStatus: MachineConnectivity.MachineStatus;
};

const MachineCell: React.FC<MachineCellProps> = ({ machineStatus }) => {
  return (
    <div className={styles.cell}>
      <Machine machineStatus={machineStatus} />
    </div>
  );
};

export default MachineCell;
