import moment from 'moment';
import React, { useState, useEffect } from 'react';
import styles from './index.less';
import { delay, floor } from 'lodash';
import { useIntl } from 'umi';
export type Style1Props = {
  autoResize: boolean;
  headerText: string;
  subTitle?: string;
  headerStyle?: object;
  style?: object;
  onHeaderClick?: () => void;
};

const Style1: React.FC<Style1Props> = ({
  autoResize,
  headerText,
  headerStyle,
  style,
  subTitle,
  children,
  onHeaderClick,
}) => {
  const intl = useIntl();
  function getWeekDayString(weekDay: number) {
    const weekList = [intl.formatMessage({id:'星期日'}), intl.formatMessage({id:'星期一'}), intl.formatMessage({id:'星期二'}), intl.formatMessage({id:'星期三'}), intl.formatMessage({id:'星期四'}), intl.formatMessage({id:'星期五'}), intl.formatMessage({id:'星期六'})];
    return weekList[weekDay];
  }
  const [scaleWidth, setScaleWidth] = useState(1);
  const [scaleHeight, setScaleHeight] = useState(1);
  const [currentDate, setCurrentDate] = useState('');
  const [currentWeek, setCurrentWeek] = useState('');
  const [currentTime, setCurrentTime] = useState('');

  const resetScale = (ar: boolean) => {
    if (ar === true) {
      setScaleWidth(floor(document.body.clientWidth / 1920, 4));
      setScaleHeight(floor(document.body.clientHeight / 1080, 4));
      delay(
        () => {
          setScaleWidth(floor(document.body.clientWidth / 1920, 4));
          setScaleHeight(floor(document.body.clientHeight / 1080, 4));
        },
        1,
        20,
      );
    } else {
      setScaleWidth(1);
      setScaleHeight(1);
    }
  };

  useEffect(() => {
    document.body.onresize = () => resetScale(autoResize);
    resetScale(autoResize);
  }, [autoResize]);

  useEffect(() => {
    const t = setInterval(() => {
      const now = moment();
      setCurrentDate(now.format('YYYY.M.D'));
      setCurrentWeek(getWeekDayString(now.isoWeekday()));
      setCurrentTime(now.format('HH:mm:ss'));
    }, 1000);
    return () => {
      clearTimeout(t);
    };
  }, []);

  return (
    <>
      <div
        className={styles.container}
        style={{
          ...style,
          transform: `scale(${scaleWidth},${scaleHeight})`,
        }}
      >
        <div className={styles.header} onClick={() => onHeaderClick && onHeaderClick()}>
          <div className={styles.headercontent} onClick={() => {}}>
            <div className={styles.leftheader}>
              {currentDate}
              <br />
              {currentWeek} {currentTime}
            </div>
            <div className={styles.centerheader} style={headerStyle}>
              {headerText}
              <div className={styles.subTitle}>{subTitle}</div>
            </div>
            <div className={styles.rightheader}>
              <br />
            </div>
          </div>
        </div>
        <div className={styles.content}>{children}</div>
      </div>
    </>
  );
};

export default Style1;
