import React, { useRef, useState } from 'react';
import { DrawerForm, ProFormCheckbox, ProFormDigit, ProFormSelect } from '@ant-design/pro-form';
import type { ProFormInstance } from '@ant-design/pro-form';
import { queryProductionProgressKanbanSetting } from '../../services/api';

type ProductionProgressKanbanSetting = KANBAN.ProductionProgress.ProductionProgressKanbanSetting;

export type Setting = {
  autoResize: boolean;
  intervalTime: number;
  rowMovingTime: number;
  productionProgressKanbanSetting?: ProductionProgressKanbanSetting;
};

export type SettingFormProps = {
  values: Partial<Setting>;
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
  onSubmitting: (setting: Setting) => Promise<any>;
};

const SettingForm: React.FC<SettingFormProps> = (props) => {
  const formRef = useRef<ProFormInstance>();
  const [productionProgressKanbanSettings, setProductionProgressKanbanSettings] = useState<
    ProductionProgressKanbanSetting[]
  >([]);

  return (
    <DrawerForm
      formRef={formRef}
      title="设置"
      width={600}
      visible={props.visible}
      onVisibleChange={(visible: boolean) => {
        if (visible) {
          formRef?.current?.setFieldsValue({
            ...props.values,
            productionProgressKanbanSettingId: props.values.productionProgressKanbanSetting?.id,
          });
        }
        props.onVisibleChange(visible);
      }}
      onFinish={async (values: {
        autoResize: boolean;
        intervalTime: number;
        rowMovingTime: number;
        productionProgressKanbanSettingId: string;
      }) => {
        const productionProgressKanbanSetting = productionProgressKanbanSettings
          .filter((a) => a.id === values.productionProgressKanbanSettingId)
          .pop();
        productionProgressKanbanSetting?.progress.steps.sort((a, b) => a.ordinal - b.ordinal);
        props.onSubmitting({ ...values, productionProgressKanbanSetting });
        props.onVisibleChange(false);
      }}
    >
      <ProFormCheckbox name="autoResize" label="适配窗口" width="xl" />
      <ProFormDigit
        name="intervalTime"
        label="刷新时间间隔（秒）"
        required
        width="xl"
        min={10}
        fieldProps={{ precision: 0 }}
      />
      <ProFormDigit
        name="rowMovingTime"
        label="内容滚动（秒）"
        required
        width="xl"
        min={1}
        fieldProps={{ precision: 0 }}
      />
      <ProFormSelect
        name="productionProgressKanbanSettingId"
        label="看板设置"
        required
        width="xl"
        request={async () => {
          const data = await queryProductionProgressKanbanSetting();
          setProductionProgressKanbanSettings(data);
          return data.map((a) => ({
            label: `${a.werks}-${a.fevor}-${a.subTitle1}-${a.subTitle2}`,
            value: a.id,
          }));
        }}
      />
    </DrawerForm>
  );
};

export default SettingForm;
