// @ts-ignore
/* eslint-disable */

import { graphql } from '@/services/common';
import { request } from 'umi';

type ProductProgressKanbanDataDto = KANBAN.ProductProgress.ProductProgressKanbanDataDto;
type ProductProgressKanbanDataCriteria = KANBAN.ProductProgress.ProductProgressKanbanDataCriteria;
type ProductProgressKanbanSetting = KANBAN.ProductProgress.ProductProgressKanbanSetting;

const productProgressKanbanSettingGraphqlString =
  'query{productProgressKanbanSetting{id,subTitle1,subTitle2,werks,fevor,overdueNone,overdueWarn,overdueSeverity,progress{steps{code,ordinal,name}}}}';

export async function queryProductProgressKanbanData(
  body: ProductProgressKanbanDataCriteria,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<ProductProgressKanbanDataDto[]>>(
    '/api/productProgressKanban/data',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
      ...(options || {}),
    },
  );
}

export async function queryProductProgressKanbanSetting() {
  const graphqlParams = {
    operationName: null,
    variables: {},
    query: productProgressKanbanSettingGraphqlString,
  };
  return (await graphql(graphqlParams)).data
    .productProgressKanbanSetting as ProductProgressKanbanSetting[];
}
