import React, { useRef, useState } from 'react';
import { DrawerForm, ProFormCheckbox, ProFormDigit, ProFormSelect } from '@ant-design/pro-form';
import type { ProFormInstance } from '@ant-design/pro-form';
import { queryProductProgressKanbanSetting } from '../../services/api';

type ProductProgressKanbanSetting = KANBAN.ProductProgress.ProductProgressKanbanSetting;

export type Setting = {
  autoResize: boolean;
  intervalTime: number;
  rowMovingTime: number;
  productProgressKanbanSetting?: ProductProgressKanbanSetting;
};

export type SettingFormProps = {
  values: Partial<Setting>;
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
  onSubmitting: (setting: Setting) => Promise<any>;
};

const SettingForm: React.FC<SettingFormProps> = (props) => {
  const formRef = useRef<ProFormInstance>();
  const [productProgressKanbanSettings, setProductProgressKanbanSettings] = useState<
    ProductProgressKanbanSetting[]
  >([]);

  return (
    <DrawerForm
      formRef={formRef}
      title="设置"
      width={600}
      visible={props.visible}
      onVisibleChange={(visible: boolean) => {
        if (visible) {
          formRef?.current?.setFieldsValue({
            ...props.values,
            productProgressKanbanSettingId: props.values.productProgressKanbanSetting?.id,
          });
        }
        props.onVisibleChange(visible);
      }}
      onFinish={async (values: {
        autoResize: boolean;
        intervalTime: number;
        rowMovingTime: number;
        productProgressKanbanSettingId: string;
      }) => {
        const productProgressKanbanSetting = productProgressKanbanSettings
          .filter((a) => a.id === values.productProgressKanbanSettingId)
          .pop();
        productProgressKanbanSetting?.progress.steps.sort((a, b) => a.ordinal - b.ordinal);
        props.onSubmitting({ ...values, productProgressKanbanSetting });
        props.onVisibleChange(false);
      }}
    >
      <ProFormCheckbox name="autoResize" label="适配窗口" width="xl" />
      <ProFormDigit
        name="intervalTime"
        label="刷新时间间隔（秒）"
        required
        width="xl"
        min={10}
        fieldProps={{ precision: 0 }}
      />
      <ProFormDigit
        name="rowMovingTime"
        label="内容滚动（秒）"
        required
        width="xl"
        min={1}
        fieldProps={{ precision: 0 }}
      />
      <ProFormSelect
        name="productProgressKanbanSettingId"
        label="看板设置"
        required
        width="xl"
        request={async () => {
          const data = await queryProductProgressKanbanSetting();
          setProductProgressKanbanSettings(data);
          return data.map((a) => ({
            label: `${a.werks}-${a.fevor}-${a.subTitle1}-${a.subTitle2}`,
            value: a.id,
          }));
        }}
      />
    </DrawerForm>
  );
};

export default SettingForm;
