// @ts-ignore
/* eslint-disable */
import { request } from 'umi';
import { MenuDataItem } from '@umijs/route-utils';
import { Modal } from 'antd';

export async function login(body: Api.LoginMgrParams, options?: { [key: string]: any }) {
  localStorage.removeItem('token');
  const resData = request<Api.LoginResult>('/login', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
  localStorage.setItem('token', (await resData).token);
  return resData;
}

export async function logout(options?: { [key: string]: any }) {
  const res = await request<Api.ServiceResult<null>>('/logout', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    ...(options || {}),
  });
  localStorage.removeItem('token');
  return res;
}

export async function currentUser(options?: { [key: string]: any }) {
  return request<Api.CurrentUser>('/getInfo', {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    ...(options || {}),
  });
}

export async function currentAccount(options?: { [key: string]: any }) {
  return request<Api.ServiceResult<Api.CurrentAccount>>('/currentAccount', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    ...(options || {}),
  });
}

export async function updatePwd(body: { [key: string]: any }, options?: { [key: string]: any }) {
  return request<Api.ServiceResult<Api.CurrentUser>>('/updatePwd', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function token(options?: { [key: string]: any }) {
  return request<Api.ServiceResult<Api.LoginResult>>('/token', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    ...(options || {}),
  });
}

export async function graphql(body: Api.GraphqlParams, options?: { [key: string]: any }) {
  return request<Api.GraphqlResult>('/graphql', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function create(entityName: string, body: any, options?: { [key: string]: any }) {
  return request<Api.ServiceResult<null>>(`/${entityName}/create`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function update(entityName: string, body: any, options?: { [key: string]: any }) {
  return request<Api.ServiceResult<null>>(`/${entityName}/update`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function importExcel(
  entityName: string,
  body: FormData,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>(`/${entityName}/excel/import`, {
    method: 'POST',
    data: body,
    skipErrorHandler: true,
    ...(options || {}),
  }).then(function (response) {
    if (response.success === false) {
      Modal.error({
        title: '异常消息',
        content: response.errorMessage,
        okText: '关闭',
      });
      const error = new Error(response.errorMessage);
      throw error;
    }
  });
}

export async function downloadImportExcelExample(
  entityName: string,
  options?: { [key: string]: any },
) {
  return request<Blob>(`/${entityName}/excel/import/example`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    responseType: 'blob',
    ...(options || {}),
  });
}

export async function remove(
  entityName: string,
  body: Api.RemoveDto,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>(`/${entityName}/remove`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function updateEmployee(
  body: Api.EmployeeUpdateParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<Api.EmployeeDto>>('/org/employee/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function createSingleTable(
  body: Api.SingleTableCreateParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function updateSingleTable(
  body: Api.SingleTableUpdateParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function removeSingleTable(body: Api.RemoveDto, options?: { [key: string]: any }) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/remove', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function createSingleTableField(
  body: Api.SingleTableFieldCreateParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/fd/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function updateSingleTableField(
  body: Api.SingleTableFieldUpdateParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/fd/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function removeSingleTableField(
  body: Api.RemoveDto,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<null>>('/qckcd/stb/fd/remove', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function getMenu(userName: string, options?: { [key: string]: any }) {
  const resData = request<Api.ServiceResult<MenuDataItem[]>>(
    `/getMenu?userName=${userName}&groupId=5`,
    {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
      data: [],
      ...(options || {}),
    },
  );
  return (await resData).data as MenuDataItem[];
}

export async function getPermission(userName: string, options?: { [key: string]: any }) {
  const resData = request<Api.ServiceResult<string[]>>(`/getPermission?userName=${userName}`, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
    },
    data: [],
    ...(options || {}),
  });
  return (await resData).data as string[];
}

export async function queryRptOee(body: Api.RptOeeQueryParams, options?: { [key: string]: any }) {
  return request<Api.ServiceResult<Api.RptOee[]>>('/report/queryrptoee', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

export async function queryRptEquipmentOee(
  body: Api.RptOeeQueryParams,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<Api.RptEquipmentOee[]>>('/report/queryrptequipmentoee', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}
