import ProTable, { ActionType } from '@ant-design/pro-table';
import { useEffect, useRef } from 'react';
import { queryProcesspunctualityPenetrating } from '../../services/api';

const ProcessOutputModalTable: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '批次号',
      dataIndex: 'lotNo',
      key: 'lotNos',
      width: 200,
    },
    {
      title: '当前所处工序',
      dataIndex: 'currentOperationName',
      key: 'currentOperationName',
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (pms: any) => {
          const sr = await queryProcesspunctualityPenetrating({
            ...params,
            pageSize: pms.pageSize,
            current: pms.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: pms.current,
            pageSize: pms.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
      />
    </>
  );
};

export default ProcessOutputModalTable;
