import React, { useRef, useState } from 'react';
import { useIntl } from 'umi';
import ProForm, {
  DrawerForm,
  ProFormCheckbox,
  ProFormDigit,
  ProFormRadio,
  ProFormSelect,
} from '@ant-design/pro-form';
import type { ProFormInstance } from '@ant-design/pro-form';
import { queryProductionComprehensKanbanData } from '../../services/api';
type KanbanSetting = KANBAN.ProductionComprehens.ProductionComprehensKanbanDataDto;

type FormSettingDto = {
  autoResize: boolean;
  intervalTime: number;
  rowMovingTime: number;
  dataRange: number;
  planSource: number;
  productionComprehensKanbanSettingId: string;
};

export type Setting = {
  autoResize: boolean;
  intervalTime: number;
  rowMovingTime: number;
  dataRange: number;
  planSource: number;
  productionComprehensKanbanSettingId?: string;
  productionComprehensKanbanSetting?: KanbanSetting;
};

export type SettingFormProps = {
  values: Partial<Setting>;
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
  onSubmitting: (setting: Setting) => Promise<any>;
};

const SettingForm: React.FC<SettingFormProps> = (props) => {
  const formRef = useRef<ProFormInstance>();
  const intl = useIntl();
  const [productionProgressKanbanSettings, setProductionProgressKanbanSettings] = useState<
    KanbanSetting[]
  >([]);

  return (
    <DrawerForm
      formRef={formRef}
      title={intl.formatMessage({id: '设置'})}
      width={600}
      submitter={{
        searchConfig: {
          resetText: intl.formatMessage({id: '取消'}),
          submitText: intl.formatMessage({id: '确认'}),
        }
      }}
      visible={props.visible}
      onVisibleChange={(visible: boolean) => {
        if (visible) {
          formRef?.current?.setFieldsValue({
            ...props.values,
            productionComprehensKanbanSettingId: props.values.productionComprehensKanbanSetting?.id,
          });
        }
        props.onVisibleChange(visible);
      }}
      onFinish={async (values: FormSettingDto) => {
        const productionComprehensKanbanSetting = productionProgressKanbanSettings
          .filter((a) => a.id === values.productionComprehensKanbanSettingId)
          .pop();
        props.onSubmitting({ ...values, productionComprehensKanbanSetting });
        props.onVisibleChange(false);
      }}
    >
      <ProFormCheckbox name="autoResize" label={intl.formatMessage({id: '适配窗口'})} width="xl" />
      <ProFormDigit
        name="intervalTime"
        label={intl.formatMessage({id: '刷新时间间隔（秒）'})}
        required
        width="xl"
        min={10}
        fieldProps={{ precision: 0 }}
      />
      <ProFormDigit
        name="rowMovingTime"
        label={intl.formatMessage({id: '内容滚动（秒）'})}
        required
        width="xl"
        min={1}
        fieldProps={{ precision: 0 }}
      />
      {/* <ProFormSelect
        name="productionComprehensKanbanSettingId"
        label="看板设置"
        required
        width="xl"
        request={async () => {
          const { data } = await queryProductionComprehensKanbanData();
          setProductionProgressKanbanSettings(data);
          return data.map((a) => ({ label: a.kanbTitle, value: a.id }));
        }}
      />
      <ProFormRadio.Group
        label="工序产量"
        name="dataRange"
        options={[
          { label: '按日', value: 1 },
          { label: '按月', value: 2 },
        ]}
      />
      <ProForm.Group>
        <ProFormRadio.Group
          name="planSource"
          options={[
            { label: '手动导入', value: 1 },
            { label: '排产计划量', value: 2 },
          ]}
        />
      </ProForm.Group> */}
    </DrawerForm>
  );
};

export default SettingForm;
