import React, { useEffect, useRef, useState } from 'react';
import * as echarts from 'echarts/lib/echarts';
import { ECharts, getInstanceByDom } from 'echarts';
import DeviceItem from './DeviceItem';
import styles from '../../index.less';
import { Modal } from 'antd';
import ProductAbnormal from '../../../materialSynthesis/components/abnormal/productAbnormal';
import { getIntl } from 'umi';

type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;
type ErrorDetailSetting = KANBAN.ProductionComprehens.ErrorDetailSetting;

const formatOptions = (data: any) => {
  const intl = getIntl();
  const option = {
    color: [
      {
        type: 'linear',
        x: 1,
        y: 0,
        x2: 0,
        y2: 0,
        colorStops: [
          {
            offset: 1,
            color: '#00214d', // 100% 处的颜色
          },
          {
            offset: 0,
            color: '#4ad4fe', // 0% 处的颜色
          },
        ],
        global: false, // 缺省为 false
      },
      {
        type: 'linear',
        x: 1,
        y: 0,
        x2: 0,
        y2: 0,
        colorStops: [
          {
            offset: 1,
            color: '#00214d',
          },
          {
            offset: 0,
            color: '#ffc000',
          },
        ],
        global: false, // 缺省为 false
      },
      {
        type: 'linear',
        x: 1,
        y: 0,
        x2: 0,
        y2: 0,
        colorStops: [
          {
            offset: 1,
            color: '#00214d',
          },
          {
            offset: 0,
            color: '#ff0000',
          },
        ],
        global: false, // 缺省为 false
      },
    ],
    legend: {
      selectedMode: false,
      itemWidth: 10,
      itemHeight: 10,
      textStyle: {
        color: '#fff',
        fontSize: 14,
      },
    },
    grid: {
      bottom: 10,
      containLabel: true,
      left: 10,
      top: 20,
    },
    xAxis: {
      type: 'value',
      show: false,
    },
    yAxis: {
      type: 'category',
      data: [intl.formatMessage({id:'生产'})],
      axisLabel: {
        color: '#fff',
        fontSize: 16,
      },
      axisTick: {
        show: false,
      },
      axisLine: {
        show: false,
      },
    },
    series: [],
  };

  const temp = {
    type: 'bar',
    name: '',
    barGap: 0,
    label: {
      show: true,
      position: 'right',
      color: '#fff',
    },
    data: [],
  };

  option.series.push({ ...temp, name: intl.formatMessage({id:'当月异常'}), data: [data.totalCt] });
  option.series.push({ ...temp, name: intl.formatMessage({id:'未关闭'}), data: [data.unCloseCt] });
  option.series.push({ ...temp, name: intl.formatMessage({id:'超期'}), data: [data.expireUnClose] });
  return option;
};

const Main: React.FC<{ data: any; setting: ErrorDetailSetting }> = ({ data, setting }) => {
  const [device, setDevice] = useState([]);
  useEffect(() => {
    setDevice(['A厂线', 'B厂线', 'C厂线', 'D厂线', 'E厂线', 'F厂线', 'G厂线'])
  }, []);

  useEffect(() => {
  }, [setting]);

  useEffect(() => {
  }, [data]);

  return (
    <>
      {data.map((v, index) => {
        if (index % 4 === 0) {
          return <div className={styles.deviceRow}>
            {data.slice(index, index+4).map((v1, index) => (
              <div className={styles.deviceContainer} >
                <DeviceItem data={v1} setting={setting} />
              </div>
            ))}
          </div>
        }
        })}
    </>
  );
};

export default Main;
