import React, { useEffect, useState } from 'react';
import KanbanStyle from '../components/FHD1080P/Style2';
import './index.less';
import Efficiency from './components/efficiency';
import MissingMaterial from './components/missingMaterial';
import PartProgress from './components/partProgress';
import PartProgressLeft from './components/partProgressLeft';
import Abnormal from './components/abnormal';
import type { Setting } from './components/SettingForm';
import SettingForm from './components/SettingForm';
import { useIntl } from 'umi';
import {
  queryCountCurrentLackMaterialKanban,
  queryCountCurrentMonthLackMaterialKanban,
  queryCountMaterialDeliveryRate,
  queryCountOrderPunctualRate,
} from './services/api';

import {
  findAbnormalOverdueSetting,
  queryComprehensiveDeviceEcpData,
  queryComprehensiveProdEcpData,
  queryComprehensiveQualityEcpData,
} from '../productionComprehens/services/api';

type AbnormalOverdueSetting = KANBAN.ProductionComprehens.AbnormalOverdueSetting;
type PartScheduleIndexData = KANBAN.MaterialSynthesis.PartScheduleIndexDataDto;
type CountCurrentLackMaterialKanbanDto = KANBAN.MaterialSynthesis.CountCurrentLackMaterialKanbanDto;
type CountCurrentMonthLackMaterialKanbanDto =
  KANBAN.MaterialSynthesis.CountCurrentMonthLackMaterialKanbanDto;
type ComprehensiveDeviceEcpDataCount = KANBAN.ProductionComprehens.ComprehensiveDeviceEcpDataCount;
type ComprehensiveDataCount = KANBAN.ProductionComprehens.ComprehensiveDataCount;

const Main: React.FC = () => {
  const [setting, setSetting] = useState<Setting>({
    autoResize: true,
    intervalTime: 600,
    rowMovingTime: 5,
    productionProgressKanbanSetting: undefined,
    kanbanId: '',
  });
  const [missingMaterialMonthData, setMissingMaterialMonthData] = useState<
    CountCurrentMonthLackMaterialKanbanDto[]
  >([]);
  const [missingMaterialLackData, setMissingMaterialLackData] = useState<
    CountCurrentLackMaterialKanbanDto[]
  >([]);
  const [settingFormVisible, setSettingFormVisible] = useState(false);
  const [partScheduleIndexData, setPartScheduleIndexData] = useState<PartScheduleIndexData[]>([]);
  const [partScheduleIndexData1, setPartScheduleIndexData1] = useState<PartScheduleIndexData[]>([]);
  const [deliveryRateData, setDeliveryRateData] = useState({
    materialDistRatio: 0,
    salesTimelyDeliveryRatio: 0,
    stockInCompleteRatio: 0
  });
  const [punctualRateData, setPunctualRateData] = useState(0);


  useEffect(() => {
    const { intervalTime } = setting;
    let t: NodeJS.Timer | null = null;

    const requestRate = async () => {
      const { data: erpData, code: erpCode } = await queryCountMaterialDeliveryRate();
      const { data: mesData, code: mesCode } = await queryCountOrderPunctualRate();
      if (erpCode === 200) {
        const {materialDistRatio, salesTimelyDeliveryRatio, salesOutboundPlanList, stockInCompleteRatio, inventoryTrend} = erpData
        setDeliveryRateData({
          materialDistRatio,
          salesTimelyDeliveryRatio,
          stockInCompleteRatio
        });
        setPartScheduleIndexData(salesOutboundPlanList || []);
        if (inventoryTrend) {
          setMissingMaterialMonthData(inventoryTrend['stockInTrend']);
          setMissingMaterialLackData(inventoryTrend['stockOutTrend']);
        }
      }
      if (mesCode === 200) {
        const { orderInfoList, stockInCompleteRatio } = mesData
        setPartScheduleIndexData1(orderInfoList)
        setPunctualRateData(stockInCompleteRatio);
      }
      
    };


    const refresh = () => {
      requestRate();
    };

    refresh();
    t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);

    return () => {
      if (t !== null) {
        clearInterval(t);
      }
    };
  }, [setting]);
  const intl = useIntl();
  // @ts-ignore
  return (
    <>
      <KanbanStyle
        headerText={intl.formatMessage({
          id: '物料综合看板'
        })}
        subTitle={setting.productionProgressKanbanSetting?.kanbTitle}
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className="material-syncthesis-container">
          <div className="left-container">
            {/* 效率图 */}
            <Efficiency
              punctual={punctualRateData}
              delivery={deliveryRateData}
              setting={{
                werks: setting.productionProgressKanbanSetting?.werks || '',
                kanbanId: setting.kanbanId,
              }}
            />
            <PartProgressLeft
              data={partScheduleIndexData1}
              rowMovingTime={setting.rowMovingTime}
            />
          </div>
          <div className="right-container">
            <MissingMaterial month={missingMaterialMonthData} lack={missingMaterialLackData} />
            <PartProgress
              data={partScheduleIndexData}
              rowMovingTime={setting.rowMovingTime}
            />
          </div>
        </div>
      </KanbanStyle>

      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default Main;
