import React, { useEffect, useRef, useState } from 'react';
import './index.less';
import { useIntl } from 'umi';


type PartScheduleIndexDataDto1 = KANBAN.MaterialSynthesis.PartScheduleIndexDataDto1;

const Main: React.FC<{ data: PartScheduleIndexDataDto1[]; rowMovingTime: any }> = ({
  data,
  rowMovingTime,
}) => {
  const intl = useIntl();
  const [nums, setNums] = useState({ total: 0, unfinish: 0 });
  let timer: NodeJS.Timer | null = null;
  const leftScroll = useRef<HTMLDivElement>(null);

  useEffect(() => {
    setNums(
      data.reduce(
        (pre, cur) => {
          pre.total += cur.planQuantity;
          pre.unfinish += cur.finishQuantity;
          return pre;
        },
        { total: 0, unfinish: 0 },
      ),
    );
    stopLoop()
    startLoop()
    return () => {
      stopLoop()
    }
  }, [rowMovingTime, data]);
  const stopLoop = () => {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  };
  const onMouseEnter = () => {
    stopLoop()
  }
  const onMouseLeave = () => {
    startLoop()
  }
  const startLoop = () => {
    stopLoop();
    if (leftScroll && leftScroll.current && (leftScroll.current.scrollTop || leftScroll.current.scrollTop === 0)) {
      timer = setInterval(() => {
        if(!leftScroll || !leftScroll.current) return
        let scrollTop = leftScroll.current.scrollTop
        console.log(scrollTop, leftScroll.current.offsetHeight, leftScroll.current.scrollHeight)
        if (scrollTop + leftScroll.current.offsetHeight + 5 >= leftScroll.current.scrollHeight) {
          leftScroll.current.scrollTo({
            top: 0, 
            behavior: 'instant',
          });
        } else {
          leftScroll.current.scrollTop += 60
        }
      }, rowMovingTime * 1000)
    }
  };
  return (
    <>
      <div className="partProgress-container" onMouseEnter={onMouseEnter}//移出关闭
    onMouseLeave={onMouseLeave}>
        <div className="title">
          <h2>{intl.formatMessage({id: '当月生产入库计划'})}</h2>
          <div className="num">
            <span>{intl.formatMessage({id: '总数量'})}：{nums.total}</span>
            <span>{intl.formatMessage({id: '完成数'})}：{nums.unfinish}</span>
          </div>
        </div>
        <div className="table-container">
          <div className="table-header">
            <div className="item" style={{flex: 0.75}}>{intl.formatMessage({id: '生产工单'})}</div>
            <div className="item">{intl.formatMessage({id: '产品名称'})}</div>
            <div className="item" style={{flex: 0.8}}>{intl.formatMessage({id: '计划完成时间'})}</div>
            <div className="item" style={{flex: 0.5}}>{intl.formatMessage({id: '计划数量'})}</div>
            <div className="item" style={{flex: 0.6}}>{intl.formatMessage({id: '完成数量'})}</div>
          </div>
          <div className="table-body" style={{height: '225px'}} ref={leftScroll}>
            {data?.map((item, index) => {
              return (
                <div className="row" key={index}>
                  <div className="item" style={{flex: 0.75}}>{item.workorderNo}</div>
                  <div className="item">{item.itemName	}</div>
                  <div className="item" style={{flex: 0.8}}>{item.planFinishDate}</div>
                  <div
                    className="item" style={{flex: 0.5}}
                  >
                    {item.planQuantity}
                  </div>
                  <div
                    className="item" style={{flex: 0.6}}
                  >
                    {item.finishQuantity}
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </div>
    </>
  );
};

export default Main;
