import { queryQualityDetail } from '@/pages/kanban/productionComprehens/services/api';
import ProTable from '@ant-design/pro-table';
import type { ActionType } from '@ant-design/pro-table';
import React, { useEffect, useRef } from 'react';
type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;

export type InfoProps = {
  values: ErrorDetailCriteria;
};

const DeviceAbnormalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '异常单号',
      dataIndex: 'exceptionNo',
      key: 'exceptionNo',
      width: 120,
    },
    {
      title: '异常单状态',
      dataIndex: 'exceptionStateName',
      key: 'exceptionStateName',
      width: 120,
    },
    {
      title: '批号',
      dataIndex: 'productionOrderNo',
      key: 'productionOrderNo',
      width: 120,
    },
    {
      title: '作业单元',
      dataIndex: 'workUnitName',
      key: 'workUnitName',
      width: 120,
    },
    {
      title: '产品编码',
      dataIndex: 'partCode',
      key: 'partCode',
      width: 120,
    },
    {
      title: '产品描述',
      dataIndex: 'partName',
      key: 'partName',
      width: 120,
    },
    {
      title: '发现工序',
      dataIndex: 'operationName',
      key: 'operationName',
      width: 120,
    },
    {
      title: '责任工序',
      dataIndex: 'dutyOperationName',
      key: 'dutyOperationName',
      width: 120,
    },
    {
      title: '异常数量',
      dataIndex: 'exceptionQuantity',
      key: 'exceptionQuantity',
      width: 120,
    },
    {
      title: '异常现象组',
      dataIndex: 'exceptionCaseGroupName',
      key: 'exceptionCaseGroupName',
      width: 120,
    },
    {
      title: '异常现象',
      dataIndex: 'exceptionCaseDetailName',
      key: 'exceptionCaseDetailName',
      width: 120,
    },
    {
      title: '异常原因组',
      dataIndex: 'exceptionReasonGroupName',
      key: 'exceptionReasonGroupName',
      width: 120,
    },
    {
      title: '异常原因',
      dataIndex: 'exceptionReasonDetailName',
      key: 'exceptionReasonDetailName',
      width: 120,
    },
    {
      title: '处理方法',
      dataIndex: 'exceptionHandlingMethodName',
      key: 'exceptionHandlingMethodName',
      width: 120,
    },
    {
      title: '创建人',
      dataIndex: 'createdByName',
      key: 'createdByName',
      width: 120,
    },
    {
      title: '创建时间',
      dataIndex: 'createdDate',
      key: 'createdDate',
      width: 120,
    },
    {
      title: '提交人',
      dataIndex: 'submittedByName',
      key: 'submittedByName',
      width: 120,
    },
    {
      title: '提交时间',
      dataIndex: 'submittedDate',
      key: 'submittedDate',
      width: 120,
    },
    {
      title: '处理人',
      dataIndex: 'handledByName',
      key: 'handledByName',
      width: 120,
    },
    {
      title: '处理时间',
      dataIndex: 'handledByName',
      key: 'handledByName',
      width: 120,
    },
    {
      title: '取消人',
      dataIndex: 'cancelledByName',
      key: 'cancelledByName',
      width: 120,
    },
    {
      title: '接收角色',
      dataIndex: 'receiverRoleName',
      key: 'receiverRoleName',
      width: 120,
    },
    {
      title: '备注',
      dataIndex: 'remarks',
      key: 'remarks',
      width: 120,
    },
    {
      title: 'DTO试环编号',
      dataIndex: 'dotTestringNo',
      key: 'dotTestringNo',
      width: 120,
    },
    {
      title: 'ISO试环编号',
      dataIndex: 'isoTestringNo',
      key: 'isoTestringNo',
      width: 120,
    },
    {
      title: 'GB试环编号',
      dataIndex: 'gbTestringNo',
      key: 'gbTestringNo',
      width: 120,
    },
    {
      title: 'ASME试环编号',
      dataIndex: 'asmeTestringNo',
      key: 'asmeTestringNo',
      width: 120,
    },
    {
      title: 'TC试环编号',
      dataIndex: 'tcTestringNo',
      key: 'tcTestringNo',
      width: 120,
    },
    {
      title: 'UN试环编号',
      dataIndex: 'unTestringNo',
      key: 'unTestringNo',
      width: 120,
    },
    {
      title: '其他试环编号',
      dataIndex: 'otherTestringNo',
      key: 'otherTestringNo',
      width: 120,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: ErrorDetailCriteria) => {
          const sr = await queryQualityDetail({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 4000 }}
      />
    </>
  );
};

export default DeviceAbnormalTable;
