import React from 'react';
import styles from './index.less';

type MachineProps = {
  machineStatus: MachineConnectivity.MachineStatus;
};

const Machine: React.FC<MachineProps> = ({ machineStatus }) => {
  const getModeName = (mode: string) => {
    switch (mode) {
      case 'Wait':
        return '等待';
      case 'Ready':
        return '等待';
      case 'Alarm':
        return '报警';
      case 'Shut_Down':
        return '停机';
      default:
        return '运行';
    }
  };

  const getModeStyle = (mode: string) => {
    switch (mode) {
      case 'Wait':
        return styles.mode_wait;
      case 'Ready':
        return styles.mode_wait;
      case 'Alarm':
        return styles.mode_alarm;
      case 'Shut_Down':
        return styles.mode_shut_down;
      default:
        return styles.mode_running;
    }
  };

  const getProgramString = (program: string | undefined) => {
    if (program) {
      if (program.length > 16) {
        return program.substring(0, 13) + '...';
      }
      return program;
    }
    return '';
  };

  return (
    <div className={machineStatus.machineName.startsWith('@') ? styles.main_hidden : styles.main}>
      <div className={styles.row0}>
        <div className={styles.row0_legend} />
        <div className={styles.row0_name}>{machineStatus.machineName}</div>
        <div className={`${styles.row0_status} ${getModeStyle(machineStatus.mode)}`}>
          {getModeName(machineStatus.mode)}
        </div>
      </div>
      <div className={styles.row1}>
        <div className={styles.row1_info}>
          <div className={styles.row1_info_header}>
            <div className={styles.row1_info_cell}>程序号</div>
            <div className={styles.row1_info_cell}>运行时长</div>
          </div>
          <div className={styles.row1_info_content}>
            <div className={styles.row1_info_cell}>{getProgramString(machineStatus.program)}</div>
            <div className={styles.row1_info_cell}>{machineStatus.runTime}</div>
          </div>
        </div>
        <div className={styles.row1_img}>
          {machineStatus.picName && machineStatus.picName.length > 0 && (
            <img
              title="Machine"
              className={styles.row1_img_img}
              src={`/machines/${machineStatus.picName}`}
            />
          )}
        </div>
      </div>
    </div>
  );
};

export default Machine;
