import moment from 'moment';
import React, { useState, useEffect } from 'react';
import styles from './index.less';
import { useIntl } from 'umi';
export type Style1Props = {
  autoResize: boolean;
  headerText: string;
  onHeaderClick?: () => void;
};
const Style1: React.FC<Style1Props> = ({ autoResize, headerText, children, onHeaderClick }) => {
  const [scaleWidth, setScaleWidth] = useState(1);
  const [scaleHeight, setScaleHeight] = useState(1);
  const [currentDate, setCurrentDate] = useState('');
  const [currentWeek, setCurrentWeek] = useState('');
  const [currentTime, setCurrentTime] = useState('');
  const intl = useIntl();
  function getWeekDayString(weekDay: number) {
    const weekList = [intl.formatMessage({id:'星期日'}), intl.formatMessage({id:'星期一'}), intl.formatMessage({id:'星期二'}), intl.formatMessage({id:'星期三'}), intl.formatMessage({id:'星期四'}), intl.formatMessage({id:'星期五'}), intl.formatMessage({id:'星期六'})];
    return weekList[weekDay];
  }
  const resetScale = (ar: boolean) => {
    if (ar === true) {
      setScaleWidth(document.body.clientWidth / 1920);
      setScaleHeight(document.body.clientHeight / 1080);
    } else {
      setScaleWidth(1);
      setScaleHeight(1);
    }
  };

  useEffect(() => {
    document.body.onresize = () => resetScale(autoResize);
    resetScale(autoResize);
  }, [autoResize]);

  useEffect(() => {
    const t = setInterval(() => {
      const now = moment();
      setCurrentDate(now.format('YYYY.M.D'));
      setCurrentWeek(getWeekDayString(now.isoWeekday()));
      setCurrentTime(now.format('HH:mm:ss'));
    }, 1000);
    return () => {
      clearTimeout(t);
    };
  }, []);

  return (
    <>
      <div
        className={styles.container}
        style={{
          transform: `scale(${scaleWidth},${scaleHeight})`,
        }}
      >
        <div className={styles.header} onClick={() => onHeaderClick && onHeaderClick()}>
          <div className={styles.headercontent} onClick={() => {}}>
            <div className={styles.leftheader}>
              CIMC <br /> ENRIC
            </div>
            <div className={styles.centerheader}>{headerText}</div>
            <div className={styles.rightheader}>
              {currentDate}
              <br />
              {currentWeek} {currentTime}
            </div>
          </div>
        </div>
        <div className={styles.content}>{children}</div>
      </div>
    </>
  );
};

export default Style1;
