import ProductAbnormal from './productAbnormal';
import QualityAbnormal from './qualityAbnormal';
import DeviceAbnormal from './deviceAbnormal';
import DeviceCountTable from './deviceCount';
import styles from '../../index.less';
import { Modal } from 'antd';
import { useState } from 'react';

type EquipmentDetailCriteria = KANBAN.QiPingComprehens.EquipmentDetailCriteria;
type ErrorDetailSetting = KANBAN.QiPingComprehens.ErrorDetailSetting;

const Abnormal: React.FC<{
  abnormalProdData: any;
  abnormalQualityData: any;
  abnormalDeviceData: any;
  setting: ErrorDetailSetting;
}> = ({ abnormalProdData, abnormalQualityData, abnormalDeviceData, setting }) => {
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [criteria, setCriteria] = useState<EquipmentDetailCriteria>();
  const closeModal = () => setIsModalOpen(false);
  const openModal = (type: number) => {
    setIsModalOpen(true);
    setCriteria({
      workshopName: setting.workshopName || '',
      current: 1,
      pageSize: 10,
      status: type,
    });
  };
  return (
    <>
      <div className={styles.itemContainer}>
        <ProductAbnormal data={abnormalProdData} setting={setting} />
      </div>
      <div className={styles.itemContainer}>
        <QualityAbnormal data={abnormalQualityData} setting={setting} />
      </div>
      <div className={styles.itemContainer}>
        <DeviceAbnormal data={abnormalDeviceData} setting={setting} />
      </div>
      <div className={styles.bottomContainer}>
        <div className={styles.bottomItem}>
          <p>设备正常数：</p>
          <h2>{abnormalDeviceData.deviceNorNumber}</h2>
        </div>
        <div className={styles.bottomItemRight} style={{ marginLeft: '10px' }}>
          <p>设备异常数：</p>
          <h2>{abnormalDeviceData.deviceEcpNumber}</h2>
        </div>
      </div>

      <Modal
        title={'设备台账'}
        visible={isModalOpen}
        footer={null}
        width={'70%'}
        onCancel={closeModal}
      >
        <DeviceCountTable values={criteria} />
      </Modal>
    </>
  );
};

export default Abnormal;
