import React, { useEffect, useRef } from 'react';
import { useIntl } from 'umi';
import ProTable, { ActionType } from '@ant-design/pro-table';
type ProcessFailProps = {
  data: KANBAN.ProductionComprehens.ProcessDefectRatioData[];
  setting: any;
};


const Main: React.FC<ProcessFailProps> = ({ data, setting }) => {
  const intl = useIntl();
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [data]);

  const columns = [
    {
      title: intl.formatMessage({
        id: '设备号'
      }),
      dataIndex: 'equipmentNo',
      key: 'equipmentNo',
      width: 80,
    },
    {
      title: intl.formatMessage({
        id: '设备'
      }),
      dataIndex: 'equipmentName',
      key: 'equipmentName',
      width: 80,
    },
    {
      title: intl.formatMessage({
        id: '原因'
      }),
      dataIndex: 'cause',
      key: 'cause',
      width: 80,
    },
    {
      title: intl.formatMessage({
        id: '状态'
      }),
      dataIndex: 'state',
      key: 'state',
      width: 80,
      valueEnum: {
        'NOT': {
          text: intl.formatMessage({
            id: '待处理'
          }),
          status: 'Error'
        },
        'SUBMIT': {
          text: intl.formatMessage({
            id: '处理中'
          })
        }
      }
    }
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        dataSource={data}
        columns={columns}
        size={'middle'}
        bordered
        pagination={false}
        scroll={{ y: 450 }}
      />
    </>
  );
};

export default Main;
