import ProTable, { ActionType } from '@ant-design/pro-table';
import { queryEquipmentDetail } from '@/pages/kanban/productionComprehens/services/api';
import React, { useEffect, useRef } from 'react';
import { Progress } from 'antd';
import { useIntl } from 'umi';
type ErrorDetailSetting = KANBAN.ProductionComprehens.ErrorDetailSetting;
import styles from '../../index.less';
export type InfoProps = {
  data: any;
  setting: ErrorDetailSetting;
};

const DeviceItem: React.FC<InfoProps> = (props) => {
  const intl = useIntl();
  useEffect(() => {
  }, [props.data]);
  useEffect(() => {
  }, [props.setting]);

  return (
    <>
      <div className={styles.deviceInner}>
        <div className={styles.deviceTop}>
          <div className={styles.deviceImg}>
          </div>
          <div className={styles.deviceTopright}>
            <p>{props.data.equipmentName}</p>
            <p>{props.data.equipmentNo}</p>
          </div>
          <div className={styles.round} style={{'background': (Number(props.data.state) === 0 ? '#1be223' : Number(props.data.state) === 1 ? '#8497b5' : '#e50105')}}></div>
        </div>
        <div className={styles.deviceBottom}>
          <div><span>{intl.formatMessage({ id: '日产出'})}: </span><span className={styles.statusNum}>{props.data.output}</span></div>
          <div><span>{intl.formatMessage({ id: '利用率'})}: </span>
          <div>
            <Progress percent={props.data.outputRatio} strokeColor={props.data.outputRatio < 50?'#ff561b':props.data.outputRatio<80?'#fef000':'#2f9a91'} className={styles.process} strokeWidth={15} /></div>
          </div>
        </div>
      </div>
    </>
  );
};

export default DeviceItem;
