import { request } from 'umi';

type PartProgressDetailCriteria = KANBAN.MaterialSynthesis.PartProgressDetailCriteria;
type PartProgressDetail = KANBAN.MaterialSynthesis.PartProgressDetail;
type MaterialChKanbanSettingDto = KANBAN.MaterialSynthesis.MaterialChKanbanSettingDto;
type PartScheduleIndexDataDto = KANBAN.MaterialSynthesis.PartScheduleIndexDataDto;
type CountCurrentLackMaterialKanbanDto = KANBAN.MaterialSynthesis.CountCurrentLackMaterialKanbanDto;
type CountCurrentMonthLackMaterialKanbanDto =
  KANBAN.MaterialSynthesis.CountCurrentMonthLackMaterialKanbanDto;
type MaterialComprehensiveKanbanDataByWorkLine =
  KANBAN.MaterialSynthesis.MaterialComprehensiveKanbanDataByWorkLine;

type KanbanDataByWorkLineDto = {
  sgNo: string;
  partName: string;
  beyondDays: number;
  backDate: number;
};
type CountMaterialDeliveryRateDto = {
  materialDistRatio: number;
  salesTimelyDeliveryRatio: number;
  salesOutboundPlanList: Array<any>;
  inventoryTrend: object;
  stockInCompleteRatio: number
};

type CountOrderPunctualRateDto = {
  orderInfoList: Array<any>;
  stockInCompleteRatio: number;
};

export async function queryMaterialChKanbanSettingList() {
  return request<Api.ServiceResult<MaterialChKanbanSettingDto[]>>(
    '/api/materialChKanbanSetting/list',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}
export async function queryPartScheduleIndexData(body: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<PartScheduleIndexDataDto[]>>(
    '/api/partScheduleIndexData/kanbanData',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
export async function queryCountCurrentLackMaterialKanban() {
  return request<Api.ServiceResult<CountCurrentLackMaterialKanbanDto[]>>(
    '/api/countCurrentLackMaterialKanban/data',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}
export async function queryCountCurrentMonthLackMaterialKanban() {
  return request<Api.ServiceResult<CountCurrentMonthLackMaterialKanbanDto[]>>(
    '/api/countCurrentMonthLackMaterialKanban/data',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}

// 物料配送完成率 物料准时配送率
export async function queryCountMaterialDeliveryRate() {
  return request<Api.ServiceResult<CountMaterialDeliveryRateDto>>(
    '/kanban/material/erpData',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      }
    },
  );
}
// 订单上线，下限准时率
export async function queryCountOrderPunctualRate() {
  return request<Api.ServiceResult<CountOrderPunctualRateDto>>(
    '/kanban/material/mesData',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      }
    },
  );
}

// 零部件进茺
export async function queryPartProgress(body: PartProgressDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<PartProgressDetail>>>(
    '/api/Kanban/GetPartsInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 零部件进茺
export async function queryMaterialComprehensiveKanbanDataByWorkLine(
  body: MaterialComprehensiveKanbanDataByWorkLine,
) {
  return request<Api.ServiceResult<KanbanDataByWorkLineDto[]>>(
    '/api/materialComprehensiveKanbanDataByWorkLine/data',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params: body,
    },
  );
}
