import React, { useEffect, useRef, useState } from 'react';
import './index.less';
import { useIntl } from 'umi';


type PartProgressDetailSetting = KANBAN.MaterialSynthesis.PartProgressDetailSetting;
type PartProgressDetailCriteria = KANBAN.MaterialSynthesis.PartProgressDetailCriteria;
type PartScheduleIndexDataDto = KANBAN.MaterialSynthesis.PartScheduleIndexDataDto;

const Main: React.FC<{ data: PartScheduleIndexDataDto[]; rowMovingTime: any }> = ({
  data,
  rowMovingTime,
}) => {
  const intl = useIntl();
  const [nums, setNums] = useState({ total: 0, unfinish: 0 });
  let timer: NodeJS.Timer | null = null;
  const leftScroll = useRef<HTMLDivElement>(null);

  useEffect(() => {
    setNums(
      data.reduce(
        (pre, cur) => {
          pre.total += cur.planQuantity;
          pre.unfinish += cur.outQuantity;
          return pre;
        },
        { total: 0, unfinish: 0 },
      ),
    );
    stopLoop()
    startLoop()
    return () => {
      stopLoop()
    }
  }, [rowMovingTime, data]);
  const stopLoop = () => {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  };
  const onMouseEnter = () => {
    stopLoop()
  }
  const onMouseLeave = () => {
    startLoop()
  }
  const startLoop = () => {
    stopLoop();
    if (leftScroll && leftScroll.current && (leftScroll.current.scrollTop || leftScroll.current.scrollTop === 0)) {
      timer = setInterval(() => {
        if(!leftScroll || !leftScroll.current) return
        let scrollTop = leftScroll.current.scrollTop
        console.log(scrollTop, leftScroll.current.offsetHeight, leftScroll.current.scrollHeight)
        if (scrollTop + leftScroll.current.offsetHeight + 5 >= leftScroll.current.scrollHeight) {
          leftScroll.current.scrollTo({
            top: 0, 
            behavior: 'instant',
          });
        } else {
          leftScroll.current.scrollTop += 60
        }
      }, rowMovingTime * 1000)
    }
  };
  return (
    <>
      <div className="partProgress-container" onMouseEnter={onMouseEnter}//移出关闭
    onMouseLeave={onMouseLeave}>
        <div className="title">
          <h2>{intl.formatMessage({id: '当月销售出库计划'})}</h2>
          <div className="num">
            <span>{intl.formatMessage({id: '总数量'})}：{nums.total}</span>
            <span>{intl.formatMessage({id: '已出库'})}：{nums.unfinish}</span>
          </div>
        </div>
        <div className="table-container">
          <div className="table-header">
            <div className="item" style={{flex: 0.7}}>{intl.formatMessage({id: '通知单号'})}</div>
            <div className="item" style={{flex: 0.9}}>{intl.formatMessage({id: '产品名称'})}</div>
            <div className="item">{intl.formatMessage({id: '计划出库时间'})}</div>
            <div className="item" style={{flex: 0.7}}>{intl.formatMessage({id: '订货数量'})}</div>
            <div className="item" style={{flex: 0.88}}>{intl.formatMessage({id: '已出库数量'})}</div>
          </div>
          <div className="table-body" style={{height: '225px'}} ref={leftScroll}>
            {data?.map((item, index) => {
              return (
                <div className="row" key={index}>
                  <div className="item" style={{flex: 0.7}}>{item.outApplyNo}</div>
                  <div className="item" style={{flex: 0.9}}>{item.itemName}</div>
                  <div className="item">{item.planOutDate}</div>
                  <div className="item" style={{flex: 0.7}}>{item.planQuantity}</div>
                  <div
                    className="item" style={{flex: 0.88}}
                  >
                    {item.outQuantity}
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </div>
    </>
  );
};

export default Main;
