import React, { useEffect, useState } from 'react';
import SettingForm from './components/SettingForm';
import type { Setting } from './components/SettingForm';
import styles from './index.less';
import KanbanStyle from '../components/FHD1080P/Style2';
import Crust1 from '../components/FHD1080P/Crust1';
import ProgressTable from './components/ProgressTable';
import { queryProductionProgressKanbanData } from './services/api';
import moment from 'moment';
import { useIntl } from 'umi';

type ProductionProgressKanbanData = KANBAN.ProductionProgress.ProductionProgressKanbanDataDto;

const Main: React.FC = () => {
  const intl = useIntl();
  const [setting, setSetting] = useState<Setting>({
    autoResize: true,
    intervalTime: 600,
    rowMovingTime: 5,
    lineName: intl.formatMessage({
      id: '全厂'
    }),
  });

  const [conditionKey, setConditionKey] = useState('');
  const [data, setData] = useState<ProductionProgressKanbanData[]>([]);
  const [settingFormVisible, setSettingFormVisible] = useState(false);

  useEffect(() => {
    const { intervalTime } = setting;
    let changeConditionKey = true;
    const refresh = () => {
      const now = Date.now();

      queryProductionProgressKanbanData({
        lineName: setting?.lineName === intl.formatMessage({
          id: '全厂'
        }) ? null : setting?.lineName
      })
        .then((value) => {
          setData(value.data);
          if (changeConditionKey) {
            changeConditionKey = false;
            setConditionKey(Date.now().toString());
          }
        })
        .catch(() => {});
    };
    refresh();
    const t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);
    return () => {
      clearTimeout(t);
    };
  }, [setting]);

  return (
    <>
      <KanbanStyle
        headerText={intl.formatMessage({id:'生产计划看板'})}
        subTitle={setting?.lineName}
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className={styles.main}>
          {/* <div className={styles.title}>
            <div className={styles.title_center} />
            <div className={styles.title_right}>
              <div className={styles.itle_right_legend_intime} />
              <div className={styles.title_right_text}>按期完成</div>
              <div className={styles.itle_right_legend_outOnetime} />
              <div className={styles.title_right_text}>超期一天完成</div>
              <div className={styles.itle_right_legend_outtime} />
              <div className={styles.title_right_text}>超期一天以上完成</div>
            </div>
          </div> */}
          <div className={styles.content}>
            <Crust1 className={styles.crust}>
              <div className={styles.content_usable}>
                {setting.lineName && (
                  <ProgressTable
                    lineName={setting.lineName}
                    data={data}
                    conditionKey={conditionKey}
                    rowMovingTime={setting.rowMovingTime}
                  />
                )}
              </div>
            </Crust1>
          </div>
        </div>
      </KanbanStyle>
      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default Main;
