import { useMemo } from 'react';
import React from 'react';
import moment from 'moment';
import styles from './index.less';

type ProductionProgressKanbanData = KANBAN.ProductionProgress.ProductionProgressKanbanDataDto;
type ProgressStep = KANBAN.ProductionProgress.ProgressStep;
type ProductionProgressKanbanSetting = KANBAN.ProductionProgress.ProductionProgressKanbanSetting;

type StepCellProps = {
  step: ProgressStep;
  data: ProductionProgressKanbanData;
  setting: ProductionProgressKanbanSetting;
};

const StepCell: React.FC<StepCellProps> = ({ step, data, setting }) => {
  const stepData = useMemo(
    () => data.stepData.filter((a) => a.stepName === step.name).pop(),
    [step, data],
  );
  const endRate = useMemo(() => {
    if (stepData) {
      return (
        ((Math.min(stepData.actualQuantity, data.planQuantity) * 100) / data.planQuantity).toFixed(
          2,
        ) + '%'
      );
    }
    return;
  }, [stepData, data]);

  /*const result = useMemo(()=>{

        return style;
    },[stepData, data])*/

  let style = '';
  if (!!!stepData) {
    return false;
  }
  if (stepData.actualQuantity >= data.planQuantity) {
    if (moment(stepData.actualEndDate).isAfter(moment(stepData.plannedEndDate))) {
      let day = moment(stepData.actualEndDate)
        .hour(0)
        .minute(0)
        .second(0)
        .millisecond(0)
        .diff(
          moment(stepData.plannedEndDate).hour(0).minute(0).second(0).millisecond(0),
          'day',
          false,
        );
      if (day < setting.overdueNone) {
        style = styles.cell_backgroud_intime;
      } else if (day >= setting.overdueWarn && day <= setting.overdueSeverity) {
        style = styles.cell_backgroud_delay_one;
      } else if (day > setting.overdueSeverity) {
        style = styles.cell_backgroud_delay;
      }
    } else {
      style = styles.cell_backgroud_intime;
    }
  } else {
    //moment(stepData.actualEndDate).
    if (moment().isAfter(stepData.plannedEndDate)) {
      style = styles.cell_backgroud_delay;
    }
  }

  return (
    <div className={styles.cell}>
      {endRate && (
        //<div className={(delay? styles.cell_backgroud_delay: styles.cell_backgroud_intime)} style={{width:endRate}} />
        <div className={style} style={{ width: endRate }} />
      )}
      <div className={styles.cell_content}>
        <div className={styles.cell_word}>{stepData?.actualQuantity}</div>
      </div>
    </div>
  );
};

export default StepCell;
