import React, { useState,useEffect, useCallback } from 'react';
import { useIntl, useModel } from 'umi';
import { useHistory } from 'react-router-dom';
import { delay, floor } from 'lodash';
import styles from './Welcome.less';
import { logout as outLogin } from '@/services/mgr/api';
const Welcome: React.FC = () => {
  const intl = useIntl();
  const { initialState, setInitialState } = useModel('@@initialState');
  const [kanbanList, setkanbanList] = useState([]);
  const [scaleWidth, setScaleWidth] = useState(1);
  const [scaleHeight, setScaleHeight] = useState(1);
  const resetScale = () => {
    setScaleWidth(floor(document.body.clientWidth / 1920, 4));
    setScaleHeight(floor(document.body.clientHeight / 1080, 4));
    delay(
      () => {
        setScaleWidth(floor(document.body.clientWidth / 1920, 4));
        setScaleHeight(floor(document.body.clientHeight / 1080, 4));
      },
      1,
      20,
    );
  };
  useEffect(() => {
    if (initialState?.menuList) {
      const menuList = initialState?.menuList
      const item = menuList.find(v => v.name === 'kanban')
      if (item?.children) {
        setkanbanList(item?.children)
      }
    }
    document.body.onresize = () => resetScale();
    resetScale()
}, []);
  const history = useHistory();
  // 跳转函数
  const goToPlaylist = (link: string) => {
    history.push(link);
  };
  const tologinOut = async () => {
    await outLogin();
    history.replace({ pathname: '/user/login' });
  };
  /**
   * 退出登录，并且将当前的 url 保存
   */
  const loginOut = useCallback(() => {
    try {
      console.log('准备退出登录')
      setInitialState((s) => ({ ...s, currentUser: undefined }));
      tologinOut();
      console.log('准备退出登录1')
    } catch (e) {
      console.log('退出失败', e)
    }
  }, [setInitialState]);
  return (
    <div className={styles.container} style={{
        transform: `scale(${scaleWidth},${scaleHeight})`,
      }}>
      <div className={styles.logout} onClick={() => loginOut()}>
        {intl.formatMessage({id:'退出登录'})}
      </div>
      <div className={styles.header}>
        <div className={styles.centerheader}>
          {intl.formatMessage({id:'希迈看板平台'})}
        </div>
      </div>
      <div className={styles.content}>
          {kanbanList.map((route) => (
            <div key={route.name} className={styles.routeItem} onClick={() => goToPlaylist(route.path)}>
              <div className={styles.routeName}>{intl.formatMessage({id: 'menu.kanban.' + route.name})}</div>
              <div className={styles.imgWapper}>
              </div>
            </div>
          ))}
      </div>
    </div>
  );
};

export default Welcome;
