// @ts-ignore
/* eslint-disable */
import { request } from 'umi';
import { graphql } from '@/services/common';
import moment from 'moment';

/**
 * 报表工序设置查询
 * @param params
 * @param options?
 */
export async function query(
  params: Report.Settings.ReportOperationSettingCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.id && params.id.length > 0) {
    specification.push(`id: {_v: eq,_val: ${params.id}}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            reportOperationSetting(
              specification:${query},
              sort:{
                orders:[{
                  pty:"reportOperation.type.id",
                  dir:asc
                },
                {
                  pty:"reportOperation.operation",
                  dir:asc
                },
                {
                  pty:"werks",
                  dir:asc
                },
                {
                  pty:"fevor",
                  dir:asc
                },
                {
                  pty:"month",
                  dir:asc
                }]
              }){
                id,
                type{
                  id,
                  name,
                },
                operation,
                werks,
                fevor,
                month,
                dailyQuantity,
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  return result.data.reportOperationSetting as Report.Settings.ReportOperationSettingDto[];
}

/**
 * 报表工序设置分页查询
 * @param params
 * @param options?
 */
export async function pageQuery(
  params: Report.Settings.ReportOperationSettingPageCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.werks && params.werks.length > 0) {
    specification.push(`werks: {_v: like,_val: "%${params.werks}%"}`);
  }
  if (params.fevor && params.fevor.length > 0) {
    specification.push(`fevor: {_v: like,_val: "%${params.fevor}%"}`);
  }
  if (params.operation && params.operation.length > 0) {
    specification.push(`operation: {_v: like,_val: "%${params.operation}%"}`);
  }
  if (params.type && params.type.name && params.type.name.length > 0) {
    specification.push(`type:{name: {_v: eq,_val: "${params.type.name}"}}`);
  }
  // 日期格式转换
  const monthRange: [string, string] = [
    moment(params.monthRange ? params.monthRange[0] : undefined)?.format('YYYY-MM-DD HH:mm:ss'),
    moment(params.monthRange ? params.monthRange[1] : undefined)?.format('YYYY-MM-DD HH:mm:ss'),
  ];
  if (
    params.monthRange &&
    monthRange &&
    monthRange[0] &&
    monthRange[0].length > 0 &&
    monthRange[1] &&
    monthRange[1].length > 0
  ) {
    specification.push(`month: {_v: btw,_val: "${monthRange[0]}",_to: "${monthRange[1]}"}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            reportOperationSettingPage(
              pageable:{
                page:${params.current - 1},
                size:${params.pageSize},
                sort:{
                    orders:[
                    {
                      pty:"type.id",
                      dir:asc
                    },
                    {
                      pty:"fevor",
                      dir:asc
                    },
                    {
                      pty:"operation",
                      dir:asc
                    },
                    {
                      pty:"month",
                      dir:asc
                    }]
                  }
                },
              specification:${query}){
                totalPages,
                totalElements,
                content{
                  id,
                  type{
                    id,
                    name,
                  },
                  operation,
                  werks,
                  fevor,
                  month,
                  dailyQuantity,
                }
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  const pageResult: Common.PageResult<Report.Settings.ReportOperationSettingDto> = {
    current: params.current,
    pageSize: params.pageSize,
    total: result.data.reportOperationSettingPage.totalElements,
    data: result.data.reportOperationSettingPage.content,
  };
  return pageResult;
}

/**
 * 报表工序设置创建
 * @param body
 * @param options
 */
export async function create(
  body: Report.Settings.ReportOperationSettingCreate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/reportOperationSetting/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 报表工序设置更新
 * @param body
 * @param options
 */
export async function update(
  body: Report.Settings.ReportOperationSettingUpdate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/reportOperationSetting/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 报表工序设置删除
 * @param body
 * @param options
 */
export async function remove(body: Common.RemoveDto, options?: { [key: string]: any }) {
  return request<Common.ServiceResult<string>>(`/api/reportOperationSetting/remove`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}
